#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PredictionUsageObjectResponse(APIObject):
    """
    Attributes
    ----------
    avg_execution_time:float
         The average predictions execution time during `timestamp` hour
    prediction_explanations:bool, none_type
         If it contains prediction explanations.
    prediction_method:str
         The prediction method that was used.
    prediction_rows_count:int
         Predictions rows count during `timestamp` hour.
    requests_count:int
         Request count during `timestamp` hour.
    server_error_count:int
         Server error count during `timestamp` hour.
    timestamp:datetime
         The timestamp of the event.
    user_error_count:int
         User error count during `timestamp` hour.
    user_id:str
         The id of the user.
    blender_model_types:str, none_type [optional]
         The type of blender model.. 
    dataset_id:str [optional]
         The id of the dataset.. 
    deployment_id:str, none_type [optional]
         The id of the deployment.. 
    deployment_type:str, none_type [optional]
         The type of deployment. 
    group_id:str, none_type [optional]
         The id of the group.. 
    group_name:str, none_type [optional]
         The name of the group.. 
    model_id:str, none_type [optional]
         The id of the model.. 
    model_type:str, none_type [optional]
         The type of the model.. 
    org_id:str, none_type [optional]
         The id of the organization.. 
    org_name:str, none_type [optional]
         The name of the organization.. 
    project_id:str, none_type [optional]
         The id of the project.. 
    project_type:str, none_type [optional]
         The type of the project.. 
    recommended_model:bool, none_type [optional]
         If it is a recommended model.. 
    user_project_role:str, none_type [optional]
         The role of the user to the related project.. 
    username:str, none_type [optional]
         The username of the user. Will be empty if ``includeIdentifyingFields`` is True.. 
    """
    _converter = t.Dict(
        {
            t.Key("avg_execution_time"):  t.Float(),
            t.Key("prediction_explanations"):  t.Bool(),
            t.Key("prediction_method"):  t.String(),
            t.Key("prediction_rows_count"):  t.Int(),
            t.Key("requests_count"):  t.Int(),
            t.Key("server_error_count"):  t.Int(),
            t.Key("timestamp"):  t.DateTime(),
            t.Key("user_error_count"):  t.Int(),
            t.Key("user_id"):  t.String(),
            t.Key("blender_model_types", optional=True):  t.String(),
            t.Key("dataset_id", optional=True):  t.String(),
            t.Key("deployment_id", optional=True):  t.String(),
            t.Key("deployment_type", optional=True):  t.String(),
            t.Key("group_id", optional=True):  t.String(),
            t.Key("group_name", optional=True):  t.String(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("model_type", optional=True):  t.String(),
            t.Key("org_id", optional=True):  t.String(),
            t.Key("org_name", optional=True):  t.String(),
            t.Key("project_id", optional=True):  t.String(),
            t.Key("project_type", optional=True):  t.String(),
            t.Key("recommended_model", optional=True):  t.Bool(),
            t.Key("user_project_role", optional=True):  t.String(),
            t.Key("username", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        avg_execution_time,
        prediction_explanations,
        prediction_method,
        prediction_rows_count,
        requests_count,
        server_error_count,
        timestamp,
        user_error_count,
        user_id,
        blender_model_types=None,
        dataset_id=None,
        deployment_id=None,
        deployment_type=None,
        group_id=None,
        group_name=None,
        model_id=None,
        model_type=None,
        org_id=None,
        org_name=None,
        project_id=None,
        project_type=None,
        recommended_model=None,
        user_project_role=None,
        username=None,
    ):
        self.avg_execution_time = avg_execution_time
        self.prediction_explanations = prediction_explanations
        self.prediction_method = prediction_method
        self.prediction_rows_count = prediction_rows_count
        self.requests_count = requests_count
        self.server_error_count = server_error_count
        self.timestamp = timestamp
        self.user_error_count = user_error_count
        self.user_id = user_id
        self.blender_model_types = blender_model_types
        self.dataset_id = dataset_id
        self.deployment_id = deployment_id
        self.deployment_type = deployment_type
        self.group_id = group_id
        self.group_name = group_name
        self.model_id = model_id
        self.model_type = model_type
        self.org_id = org_id
        self.org_name = org_name
        self.project_id = project_id
        self.project_type = project_type
        self.recommended_model = recommended_model
        self.user_project_role = user_project_role
        self.username = username

    def __repr__(self):
        return (
            "PredictionUsageObjectResponse("
            "avg_execution_time={0.avg_execution_time}, "
            "prediction_explanations={0.prediction_explanations}, "
            "prediction_method={0.prediction_method}, "
            "prediction_rows_count={0.prediction_rows_count}, "
            "requests_count={0.requests_count}, "
            "server_error_count={0.server_error_count}, "
            "timestamp={0.timestamp}, "
            "user_error_count={0.user_error_count}, "
            "user_id={0.user_id}, "
            "blender_model_types={0.blender_model_types}, "
            "dataset_id={0.dataset_id}, "
            "deployment_id={0.deployment_id}, "
            "deployment_type={0.deployment_type}, "
            "group_id={0.group_id}, "
            "group_name={0.group_name}, "
            "model_id={0.model_id}, "
            "model_type={0.model_type}, "
            "org_id={0.org_id}, "
            "org_name={0.org_name}, "
            "project_id={0.project_id}, "
            "project_type={0.project_type}, "
            "recommended_model={0.recommended_model}, "
            "user_project_role={0.user_project_role}, "
            "username={0.username}, "
        ).format(self)
