#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PreloadedCalendar(APIObject):
    """
    Attributes
    ----------
    country_code:str
         Code of the country for which holidays should be generated. Code needs to be uppercase and should belong to the list of countries which can be retrieved via :http:get:`/api/v2/calendarCountryCodes/`
    end_date:datetime
         Last date of the range of dates for which holidays are generated.
    start_date:datetime
         First date of the range of dates for which holidays are generated.
    """
    _converter = t.Dict(
        {
            t.Key("country_code"):  t.String(),
            t.Key("end_date"):  t.DateTime(),
            t.Key("start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        country_code,
        end_date,
        start_date,
    ):
        self.country_code = country_code
        self.end_date = end_date
        self.start_date = start_date

    def __repr__(self):
        return (
            "PreloadedCalendar("
            "country_code={0.country_code}, "
            "end_date={0.end_date}, "
            "start_date={0.start_date}, "
        ).format(self)
