#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PrimeFileResponse(APIObject):
    """
    Attributes
    ----------
    id:str
         the ID of the file
    is_valid:bool
         whether the code passed basic validation checks
    language:str
         the language the code is written in (e.g. Python
    model_id:str
         the Id of the Prime model
    parent_model_id:str
         the ID of the model this code approximates
    project_id:str
         the ID of the project the file belongs to
    ruleset_id:int
         the ID of the ruleset this code uses to approximate the parent model
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("is_valid"):  t.Bool(),
            t.Key("language"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("parent_model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("ruleset_id"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        is_valid,
        language,
        model_id,
        parent_model_id,
        project_id,
        ruleset_id,
    ):
        self.id = id
        self.is_valid = is_valid
        self.language = language
        self.model_id = model_id
        self.parent_model_id = parent_model_id
        self.project_id = project_id
        self.ruleset_id = ruleset_id

    def __repr__(self):
        return (
            "PrimeFileResponse("
            "id={0.id}, "
            "is_valid={0.is_valid}, "
            "language={0.language}, "
            "model_id={0.model_id}, "
            "parent_model_id={0.parent_model_id}, "
            "project_id={0.project_id}, "
            "ruleset_id={0.ruleset_id}, "
        ).format(self)
