#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PrimeInfoRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    can_make_prime:bool
         Indicating whether the requested model is a valid input for creating a Prime mode
    message:str
         May contain details about why a model is not eligible for DataRobotPrime
    message_id:int
         An error code representing the reason the model cannot be approximated with DataRobot Prime; 0 for eligible models
    """
    _converter = t.Dict(
        {
            t.Key("can_make_prime"):  t.Bool(),
            t.Key("message"):  t.String(),
            t.Key("message_id"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        can_make_prime,
        message,
        message_id,
    ):
        self.can_make_prime = can_make_prime
        self.message = message
        self.message_id = message_id

    def __repr__(self):
        return (
            "PrimeInfoRetrieveResponse("
            "can_make_prime={0.can_make_prime}, "
            "message={0.message}, "
            "message_id={0.message_id}, "
        ).format(self)
