#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class PrimeRulesetsListResponse(APIObject):
    """
    Attributes
    ----------
    model_id:str
         the ID of the Prime model using this ruleset (if it exists) or null
    parent_model_id:str
         ID of the model this ruleset approximates
    project_id:str
         the project this ruleset belongs to
    rule_count:int
         the number of rules used by this ruleset
    ruleset_id:int
         the ID of the ruleset
    score:float
         the validation score of the ruleset
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("parent_model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("rule_count"):  t.Int(),
            t.Key("ruleset_id"):  t.Int(),
            t.Key("score"):  t.Float(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        parent_model_id,
        project_id,
        rule_count,
        ruleset_id,
        score,
    ):
        self.model_id = model_id
        self.parent_model_id = parent_model_id
        self.project_id = project_id
        self.rule_count = rule_count
        self.ruleset_id = ruleset_id
        self.score = score

    def __repr__(self):
        return (
            "PrimeRulesetsListResponse("
            "model_id={0.model_id}, "
            "parent_model_id={0.parent_model_id}, "
            "project_id={0.project_id}, "
            "rule_count={0.rule_count}, "
            "ruleset_id={0.ruleset_id}, "
            "score={0.score}, "
        ).format(self)
