#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ProjectAdvancedOptionsResponse(APIObject):
    """
    Attributes
    ----------
    blend_best_models:bool
         blend best models during Autopilot run
    blueprint_threshold:int, none_type
         an upper bound on running time (in hours), such that models exceeding the bound will be excluded in subsequent autopilot runs
    default_monotonic_decreasing_featurelist_id:str, none_type
         null or str, the ID of the featurelist specifying a set of features with a monotonically decreasing relationship to the target. All blueprints generated in the project use this as their default monotonic constraint, but it can be overriden at model submission time.
    default_monotonic_increasing_featurelist_id:str, none_type
         null or str, the ID of the featurelist specifying a set of features with a monotonically increasing relationship to the target. All blueprints generated in the project use this as their default monotonic constraint, but it can be overriden at model submission time.
    downsampled_majority_rows:int, none_type
         the total number of the majority rows available for modeling, or null for projects without smart downsampling
    downsampled_minority_rows:int, none_type
         the total number of the minority rows available for modeling, or null for projects without smart downsampling
    majority_downsampling_rate:float, none_type
         the percentage between 0 and 100 of the majority rows that are kept, or null for projects without smart downsampling
    only_include_monotonic_blueprints:bool
         whether the project only includes blueprints support enforcing monotonic constraints. defaults to False
    prepare_model_for_deployment:bool, none_type
         Prepare model for deployment during Autopilot run. The preparation includes creating reduced feature list models, retraining best model on higher sample size, computing insights and assigning \"RECOMMENDED FOR DEPLOYMENT\" label.
    response_cap:bool, date, datetime, dict, float, int, list, str, none_type
         defaults to False, if specified used to cap the maximum response of a model
    scaleout_modeling_mode:str, none_type
         Specifies the behavior of Scaleout models for the projectwithout smart downsampling
    scoring_code_only:bool
         Keep only models that can be converted to scorable java code during Autopilot run.
    seed:str, none_type
         defaults to null, the random seed to be used if specified
    shap_only_mode:bool, none_type
         Keep only models that support SHAP values during Autopilot run. Use SHAP-based insights wherever possible. For pre SHAP-only mode projects this is always ``null``.
    smart_downsampled:bool
         whether the project uses smart downsampling to throw away excess rows of the majority class.  Smart downsampled projects express all sample percents in terms of percent of minority rows (as opposed to percent of all rows).
    weights:str, none_type
         the name of the weight column, if specified, otherwise null.
    allowed_pairwise_interaction_groups:[[str]] [optional]
         For GAM models - specify groups of columns for which pairwise interactions will be allowed. E.g. if set to [[\"A\", \"B\", \"C\"], [\"C\", \"D\"]] then GAM models will allow interactions between columns AxB, BxC, AxC, CxD. All others (AxD, BxD) will not be considered. If not specified - all possible interactions will be considered by model.. 
    consider_blenders_in_recommendation:bool [optional]
         Include blenders when selecting a model to prepare for deployment in an Autopilot Run.. 
    events_count:str, none_type [optional]
         the name of the event count column, if specified, otherwise null.. 
    exposure:str, none_type [optional]
         the name of the exposure column, if specified.. 
    min_secondary_validation_model_count:bool [optional]
         Compute \"All backtest\" scores (datetime models) or cross validation scores for the specified number of highest ranking models on the Leaderboard, if over the Autopilot default.. 
    offset:[str], none_type [optional]
         the list of names of the offset columns, if specified, otherwise null.. 
    run_leakage_removed_feature_list:bool [optional]
         Run Autopilot on Leakage Removed feature list (if exists).. 
    """
    _converter = t.Dict(
        {
            t.Key("blend_best_models"):  t.Bool(),
            t.Key("blueprint_threshold"):  t.Int(),
            t.Key("default_monotonic_decreasing_featurelist_id"):  t.String(),
            t.Key("default_monotonic_increasing_featurelist_id"):  t.String(),
            t.Key("downsampled_majority_rows"):  t.Int(),
            t.Key("downsampled_minority_rows"):  t.Int(),
            t.Key("majority_downsampling_rate"):  t.Float(),
            t.Key("only_include_monotonic_blueprints"):  t.Bool(),
            t.Key("prepare_model_for_deployment"):  t.Bool(),
            t.Key("response_cap"):  t.Any(),
            t.Key("scaleout_modeling_mode"):  t.String(),
            t.Key("scoring_code_only"):  t.Bool(),
            t.Key("seed"):  t.String(),
            t.Key("shap_only_mode"):  t.Bool(),
            t.Key("smart_downsampled"):  t.Bool(),
            t.Key("weights"):  t.String(),
            t.Key("allowed_pairwise_interaction_groups", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("consider_blenders_in_recommendation", optional=True):  t.Bool(),
            t.Key("events_count", optional=True):  t.String(),
            t.Key("exposure", optional=True):  t.String(),
            t.Key("min_secondary_validation_model_count", optional=True):  t.Bool(),
            t.Key("offset", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("run_leakage_removed_feature_list", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blend_best_models,
        blueprint_threshold,
        default_monotonic_decreasing_featurelist_id,
        default_monotonic_increasing_featurelist_id,
        downsampled_majority_rows,
        downsampled_minority_rows,
        majority_downsampling_rate,
        only_include_monotonic_blueprints,
        prepare_model_for_deployment,
        response_cap,
        scaleout_modeling_mode,
        scoring_code_only,
        seed,
        shap_only_mode,
        smart_downsampled,
        weights,
        allowed_pairwise_interaction_groups=None,
        consider_blenders_in_recommendation=None,
        events_count=None,
        exposure=None,
        min_secondary_validation_model_count=None,
        offset=None,
        run_leakage_removed_feature_list=None,
    ):
        self.blend_best_models = blend_best_models
        self.blueprint_threshold = blueprint_threshold
        self.default_monotonic_decreasing_featurelist_id = default_monotonic_decreasing_featurelist_id
        self.default_monotonic_increasing_featurelist_id = default_monotonic_increasing_featurelist_id
        self.downsampled_majority_rows = downsampled_majority_rows
        self.downsampled_minority_rows = downsampled_minority_rows
        self.majority_downsampling_rate = majority_downsampling_rate
        self.only_include_monotonic_blueprints = only_include_monotonic_blueprints
        self.prepare_model_for_deployment = prepare_model_for_deployment
        self.response_cap = response_cap
        self.scaleout_modeling_mode = scaleout_modeling_mode
        self.scoring_code_only = scoring_code_only
        self.seed = seed
        self.shap_only_mode = shap_only_mode
        self.smart_downsampled = smart_downsampled
        self.weights = weights
        self.allowed_pairwise_interaction_groups = allowed_pairwise_interaction_groups
        self.consider_blenders_in_recommendation = consider_blenders_in_recommendation
        self.events_count = events_count
        self.exposure = exposure
        self.min_secondary_validation_model_count = min_secondary_validation_model_count
        self.offset = offset
        self.run_leakage_removed_feature_list = run_leakage_removed_feature_list

    def __repr__(self):
        return (
            "ProjectAdvancedOptionsResponse("
            "blend_best_models={0.blend_best_models}, "
            "blueprint_threshold={0.blueprint_threshold}, "
            "default_monotonic_decreasing_featurelist_id={0.default_monotonic_decreasing_featurelist_id}, "
            "default_monotonic_increasing_featurelist_id={0.default_monotonic_increasing_featurelist_id}, "
            "downsampled_majority_rows={0.downsampled_majority_rows}, "
            "downsampled_minority_rows={0.downsampled_minority_rows}, "
            "majority_downsampling_rate={0.majority_downsampling_rate}, "
            "only_include_monotonic_blueprints={0.only_include_monotonic_blueprints}, "
            "prepare_model_for_deployment={0.prepare_model_for_deployment}, "
            "response_cap={0.response_cap}, "
            "scaleout_modeling_mode={0.scaleout_modeling_mode}, "
            "scoring_code_only={0.scoring_code_only}, "
            "seed={0.seed}, "
            "shap_only_mode={0.shap_only_mode}, "
            "smart_downsampled={0.smart_downsampled}, "
            "weights={0.weights}, "
            "allowed_pairwise_interaction_groups={0.allowed_pairwise_interaction_groups}, "
            "consider_blenders_in_recommendation={0.consider_blenders_in_recommendation}, "
            "events_count={0.events_count}, "
            "exposure={0.exposure}, "
            "min_secondary_validation_model_count={0.min_secondary_validation_model_count}, "
            "offset={0.offset}, "
            "run_leakage_removed_feature_list={0.run_leakage_removed_feature_list}, "
        ).format(self)
