#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ProjectCreate(APIObject):
    """
    Attributes
    ----------
    credential_data:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         The credentials to authenticate with the database, to be used instead of credential ID. Can only be used along with datasetId or dataSourceId.. 
    credential_id:str [optional]
         The ID of the set of credentials to authenticate with the database. Can only be used along with datasetId or dataSourceId.. 
    data_source_id:str [optional]
         Identifier for the data source to retrieve.. 
    dataset_id:str [optional]
         The ID of the dataset entry to use for the project dataset.. 
    dataset_version_id:str [optional]
         Only used when also providing a datasetId, and specifies the the ID of the dataset version to use for the project dataset. If not specified, the latest version associated with the dataset ID is used.. 
    password:str [optional]
         The password (in cleartext) for database authentication. The password will be encrypted on the server side as part of the HTTP request and never saved or stored. Can only be used along with datasetId or dataSourceId. DEPRECATED: please use credentialId or credentialData instead.. 
    project_name:str [optional]
         The name of the project to be created. If not specified, 'Untitled Project' will be used for database connections and file name will be used as the project name.. 
    url:str [optional]
         The URL to download the dataset used to create the project.. 
    use_kerberos:bool [optional]
         If true, use Kerberos authentication for database authentication. Default is false. Can only be used along with datasetId or dataSourceId.. 
    user:str [optional]
         The username for database authentication. Can only be used along with datasetId or dataSourceId. DEPRECATED: please use credentialId or credentialData instead.. 
    """
    _converter = t.Dict(
        {
            t.Key("credential_data", optional=True):  t.Any(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("data_source_id", optional=True):  t.String(),
            t.Key("dataset_id", optional=True):  t.String(),
            t.Key("dataset_version_id", optional=True):  t.String(),
            t.Key("password", optional=True):  t.String(),
            t.Key("project_name", optional=True):  t.String(),
            t.Key("url", optional=True):  t.String(),
            t.Key("use_kerberos", optional=True):  t.Bool(),
            t.Key("user", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_data=None,
        credential_id=None,
        data_source_id=None,
        dataset_id=None,
        dataset_version_id=None,
        password=None,
        project_name=None,
        url=None,
        use_kerberos=None,
        user=None,
    ):
        self.credential_data = credential_data
        self.credential_id = credential_id
        self.data_source_id = data_source_id
        self.dataset_id = dataset_id
        self.dataset_version_id = dataset_version_id
        self.password = password
        self.project_name = project_name
        self.url = url
        self.use_kerberos = use_kerberos
        self.user = user

    def __repr__(self):
        return (
            "ProjectCreate("
            "credential_data={0.credential_data}, "
            "credential_id={0.credential_id}, "
            "data_source_id={0.data_source_id}, "
            "dataset_id={0.dataset_id}, "
            "dataset_version_id={0.dataset_version_id}, "
            "password={0.password}, "
            "project_name={0.project_name}, "
            "url={0.url}, "
            "use_kerberos={0.use_kerberos}, "
            "user={0.user}, "
        ).format(self)
