#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.project_advanced_options_response import ProjectAdvancedOptionsResponse
from datarobot.models.full_api.generated.model.project_partition_response import ProjectPartitionResponse
from datarobot.models.full_api.generated.model.project_recommender_response import ProjectRecommenderResponse

class ProjectDetailsResponse(APIObject):
    """
    Attributes
    ----------
    advanced_options:ProjectAdvancedOptionsResponse
        
    autopilot_mode:int
         The the current autopilot mode, either 0 for full autopilot or 2 for manual mode.
    created:datetime
         The time of project creation.
    file_name:str
         The name of the dataset used to create the project.
    holdout_unlocked:bool
         whether the holdout has been unlocked
    id:str
         The ID of a project.
    max_train_pct:float
         the maximum percentage of the dataset that can be used to successfully train a model without going into the validation data.
    max_train_rows:int
         the maximum number of rows of the dataset that can be used to successfully train a model without going into the validation data
    metric:str
         the metric used to select the best-performing models.
    partition:ProjectPartitionResponse
        
    positive_class:float, none_type
         if the project uses binary classification, the class designated to be the positive class.  Otherwise, null.
    project_name:str
         The name of a project.
    recommender:ProjectRecommenderResponse
        
    scaleout_max_train_pct:float
         the maximum percentage of the dataset that can be used to successfully train a scaleout model without going into the validation data.  May exceed `maxTrainPct`, in which case only scaleout models can be trained up to this point.
    scaleout_max_train_rows:int
         the maximum number of rows of the dataset that can used be used to successfully train a scaleout model without going into the validation data.  May exceed `maxTrainRows`, in which case only scaleout models can be trained up to this point.
    stage:str
         the stage of the project - if modeling, then the target is successfully set, and modeling or predictions can proceed.
    target:str
         the target of the project, null if project is unsupervised.
    target_type:str, none_type
         The target type of the project.
    unsupervised_mode:bool
         indicates whether a project is unsupervised.
    use_feature_discovery:bool
         A boolean value indicating whether a feature discovery project was created as opposed to a regular project.
    autopilot_cluster_list:[int], none_type [optional]
         Optional. A list of integers where each value will be used as the number of clusters in Autopilot model(s) for unsupervised clustering projects. Cannot be specified unless unsupervisedMode is true and unsupervisedType is set to 'clustering'.. 
    feature_engineering_prediction_point:str, none_type [optional]
         The date column to be used as prediction point for time-based feature engineering.. 
    max_clusters:int, none_type [optional]
         Only valid when unsupervisedMode is True and unsupervisedType is 'clustering'. The maximum number of clusters allowed when training clustering models. If specified cannot be exceed the number of rows in a project's dataset divided by 50 and must be less than or equal to `minClusters`. If unsupervisedMode is True and unsupervisedType is 'clustering' then defaults to the number of rows in the project's dataset divided by 50 or 100 if that number of greater than 100.. 
    min_clusters:int, none_type [optional]
         Only valid when unsupervisedMode is True and unsupervisedType is 'clustering'. The minimum number of clusters allowed when training clustering models. If specified cannot be exceed the number of rows in a project's dataset divided by 50 and must be less than or equal to `maxClusters`. If unsupervisedMode is True and  unsupervisedType is 'clustering' then defaults to 2.. 
    unsupervised_type:str, none_type [optional]
         Only valid when unsupervisedMode is True. The type of unsupervised project, anomaly or clustering. If unsupervisedMode, defaults to 'anomaly'.. 
    """
    _converter = t.Dict(
        {
            t.Key("advanced_options"):  t.Any(),
            t.Key("autopilot_mode"):  t.Int(),
            t.Key("created"):  t.DateTime(),
            t.Key("file_name"):  t.String(),
            t.Key("holdout_unlocked"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("max_train_pct"):  t.Float(),
            t.Key("max_train_rows"):  t.Int(),
            t.Key("metric"):  t.String(),
            t.Key("partition"):  t.Any(),
            t.Key("positive_class"):  t.Float(),
            t.Key("project_name"):  t.String(),
            t.Key("recommender"):  t.Any(),
            t.Key("scaleout_max_train_pct"):  t.Float(),
            t.Key("scaleout_max_train_rows"):  t.Int(),
            t.Key("stage"):  t.String(),
            t.Key("target"):  t.String(),
            t.Key("target_type"):  t.String(),
            t.Key("unsupervised_mode"):  t.Bool(),
            t.Key("use_feature_discovery"):  t.Bool(),
            t.Key("autopilot_cluster_list", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature_engineering_prediction_point", optional=True):  t.String(),
            t.Key("max_clusters", optional=True):  t.Int(),
            t.Key("min_clusters", optional=True):  t.Int(),
            t.Key("unsupervised_type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        advanced_options,
        autopilot_mode,
        created,
        file_name,
        holdout_unlocked,
        id,
        max_train_pct,
        max_train_rows,
        metric,
        partition,
        positive_class,
        project_name,
        recommender,
        scaleout_max_train_pct,
        scaleout_max_train_rows,
        stage,
        target,
        target_type,
        unsupervised_mode,
        use_feature_discovery,
        autopilot_cluster_list=None,
        feature_engineering_prediction_point=None,
        max_clusters=None,
        min_clusters=None,
        unsupervised_type=None,
    ):
        self.advanced_options = advanced_options
        self.autopilot_mode = autopilot_mode
        self.created = created
        self.file_name = file_name
        self.holdout_unlocked = holdout_unlocked
        self.id = id
        self.max_train_pct = max_train_pct
        self.max_train_rows = max_train_rows
        self.metric = metric
        self.partition = partition
        self.positive_class = positive_class
        self.project_name = project_name
        self.recommender = recommender
        self.scaleout_max_train_pct = scaleout_max_train_pct
        self.scaleout_max_train_rows = scaleout_max_train_rows
        self.stage = stage
        self.target = target
        self.target_type = target_type
        self.unsupervised_mode = unsupervised_mode
        self.use_feature_discovery = use_feature_discovery
        self.autopilot_cluster_list = autopilot_cluster_list
        self.feature_engineering_prediction_point = feature_engineering_prediction_point
        self.max_clusters = max_clusters
        self.min_clusters = min_clusters
        self.unsupervised_type = unsupervised_type

    def __repr__(self):
        return (
            "ProjectDetailsResponse("
            "advanced_options={0.advanced_options}, "
            "autopilot_mode={0.autopilot_mode}, "
            "created={0.created}, "
            "file_name={0.file_name}, "
            "holdout_unlocked={0.holdout_unlocked}, "
            "id={0.id}, "
            "max_train_pct={0.max_train_pct}, "
            "max_train_rows={0.max_train_rows}, "
            "metric={0.metric}, "
            "partition={0.partition}, "
            "positive_class={0.positive_class}, "
            "project_name={0.project_name}, "
            "recommender={0.recommender}, "
            "scaleout_max_train_pct={0.scaleout_max_train_pct}, "
            "scaleout_max_train_rows={0.scaleout_max_train_rows}, "
            "stage={0.stage}, "
            "target={0.target}, "
            "target_type={0.target_type}, "
            "unsupervised_mode={0.unsupervised_mode}, "
            "use_feature_discovery={0.use_feature_discovery}, "
            "autopilot_cluster_list={0.autopilot_cluster_list}, "
            "feature_engineering_prediction_point={0.feature_engineering_prediction_point}, "
            "max_clusters={0.max_clusters}, "
            "min_clusters={0.min_clusters}, "
            "unsupervised_type={0.unsupervised_type}, "
        ).format(self)
