#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ProjectNuke(APIObject):
    """
    Attributes
    ----------
    creator:str [optional]
         Creator ID to filter projects by. 
    deleted_after:datetime [optional]
         ISO-8601 formatted date projects were deleted after. 
    deleted_before:datetime [optional]
         ISO-8601 formatted date projects were deleted before. 
    limit:int [optional]
         At most this many projects are deleted..  if omitted the server will use the default value of 1000
    offset:int [optional]
         This many projects will be skipped..  if omitted the server will use the default value of 0
    organization:str [optional]
         ID of organization that projects should belong to. 
    project_ids:[str] [optional]
         List of project IDs to delete permanently.. 
    search_for:str [optional]
         Project or dataset name to filter by. 
    """
    _converter = t.Dict(
        {
            t.Key("creator", optional=True):  t.String(),
            t.Key("deleted_after", optional=True):  t.DateTime(),
            t.Key("deleted_before", optional=True):  t.DateTime(),
            t.Key("limit", optional=True):  t.Int(),
            t.Key("offset", optional=True):  t.Int(),
            t.Key("organization", optional=True):  t.String(),
            t.Key("project_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("search_for", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        creator=None,
        deleted_after=None,
        deleted_before=None,
        limit=None,
        offset=None,
        organization=None,
        project_ids=None,
        search_for=None,
    ):
        self.creator = creator
        self.deleted_after = deleted_after
        self.deleted_before = deleted_before
        self.limit = limit
        self.offset = offset
        self.organization = organization
        self.project_ids = project_ids
        self.search_for = search_for

    def __repr__(self):
        return (
            "ProjectNuke("
            "creator={0.creator}, "
            "deleted_after={0.deleted_after}, "
            "deleted_before={0.deleted_before}, "
            "limit={0.limit}, "
            "offset={0.offset}, "
            "organization={0.organization}, "
            "project_ids={0.project_ids}, "
            "search_for={0.search_for}, "
        ).format(self)
