#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.project_permadelete_status import ProjectPermadeleteStatus

class ProjectNukeJobStatus(APIObject):
    """
    Attributes
    ----------
    created:datetime
         The time the status record was created.
    data:[ProjectPermadeleteStatus]
         List of projects and associated statuses.
    message:str, none_type
         May contain further information about the status.
    status:str
         The processing state of the cleanup job.
    status_id:str
         The ID of the status object.
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.DateTime(),
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("message"):  t.String(),
            t.Key("status"):  t.String(),
            t.Key("status_id"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        data,
        message,
        status,
        status_id,
    ):
        self.created = created
        self.data = data
        self.message = message
        self.status = status
        self.status_id = status_id

    def __repr__(self):
        return (
            "ProjectNukeJobStatus("
            "created={0.created}, "
            "data={0.data}, "
            "message={0.message}, "
            "status={0.status}, "
            "status_id={0.status_id}, "
        ).format(self)
