#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ProjectPartitionResponse(APIObject):
    """
    Attributes
    ----------
    cv_holdout_level:bool, date, datetime, dict, float, int, list, str, none_type
         if a user partition column was used with cross validation, the value assigned to the holdout set
    cv_method:str
         the partitioning method used. Note that \"date\" partitioning is an old partitioning method no longer supported for new projects, as of API version v2.0.
    datetime_col:str, none_type
         if a date partition column was used, the name of the column. Note that datetimeCol applies to an old partitioning method no longer supported for new projects, as of API version v2.0.
    holdout_level:bool, date, datetime, dict, float, int, list, str, none_type
         if a user partition column was used with train-validation-holdout split, the value assigned to the holdout set
    holdout_pct:float
         the percentage of the dataset reserved for the holdout set
    partition_key_cols:str, none_type
         if group partitioning was used, the name of the column.
    reps:float, none_type
         if cross validation was used, the number of folds to use
    training_level:bool, date, datetime, dict, float, int, list, str, none_type
         if a user partition column was used with train-validation-holdout split, the value assigned to the training set
    use_time_series:bool, none_type
         A boolean value indicating whether a time series project was created as opposed to a regular project using datetime partitioning.
    user_partition_col:str, none_type
         if a user partition column was used, the name of the column
    validation_level:bool, date, datetime, dict, float, int, list, str, none_type
         if a user partition column was used with train-validation-holdout split, the value assigned to the validation set
    validation_pct:float, none_type
         if train-validation-holdout split was used, the percentage of the dataset used for the validation set
    validation_type:str
         either CV for cross-validation or TVH for train-validation-holdout split
    datetime_partition_column:str [optional]
         if a datetime partition column was used, the name of the column. 
    """
    _converter = t.Dict(
        {
            t.Key("cv_holdout_level"):  t.Any(),
            t.Key("cv_method"):  t.String(),
            t.Key("datetime_col"):  t.String(),
            t.Key("holdout_level"):  t.Any(),
            t.Key("holdout_pct"):  t.Float(),
            t.Key("partition_key_cols"):  t.String(),
            t.Key("reps"):  t.Float(),
            t.Key("training_level"):  t.Any(),
            t.Key("use_time_series"):  t.Bool(),
            t.Key("user_partition_col"):  t.String(),
            t.Key("validation_level"):  t.Any(),
            t.Key("validation_pct"):  t.Float(),
            t.Key("validation_type"):  t.String(),
            t.Key("datetime_partition_column", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        cv_holdout_level,
        cv_method,
        datetime_col,
        holdout_level,
        holdout_pct,
        partition_key_cols,
        reps,
        training_level,
        use_time_series,
        user_partition_col,
        validation_level,
        validation_pct,
        validation_type,
        datetime_partition_column=None,
    ):
        self.cv_holdout_level = cv_holdout_level
        self.cv_method = cv_method
        self.datetime_col = datetime_col
        self.holdout_level = holdout_level
        self.holdout_pct = holdout_pct
        self.partition_key_cols = partition_key_cols
        self.reps = reps
        self.training_level = training_level
        self.use_time_series = use_time_series
        self.user_partition_col = user_partition_col
        self.validation_level = validation_level
        self.validation_pct = validation_pct
        self.validation_type = validation_type
        self.datetime_partition_column = datetime_partition_column

    def __repr__(self):
        return (
            "ProjectPartitionResponse("
            "cv_holdout_level={0.cv_holdout_level}, "
            "cv_method={0.cv_method}, "
            "datetime_col={0.datetime_col}, "
            "holdout_level={0.holdout_level}, "
            "holdout_pct={0.holdout_pct}, "
            "partition_key_cols={0.partition_key_cols}, "
            "reps={0.reps}, "
            "training_level={0.training_level}, "
            "use_time_series={0.use_time_series}, "
            "user_partition_col={0.user_partition_col}, "
            "validation_level={0.validation_level}, "
            "validation_pct={0.validation_pct}, "
            "validation_type={0.validation_type}, "
            "datetime_partition_column={0.datetime_partition_column}, "
        ).format(self)
