#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.external_ts_baseline_metadata import ExternalTSBaselineMetadata
from datarobot.models.full_api.generated.model.partition import Partition
from datarobot.models.full_api.generated.model.project_advanced_options_response import ProjectAdvancedOptionsResponse
from datarobot.models.full_api.generated.model.project_segmentation_info_response import ProjectSegmentationInfoResponse
from datarobot.models.full_api.generated.model.recommender import Recommender

class ProjectRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    advanced_options:ProjectAdvancedOptionsResponse
        
    automodel_deployment_id:str, none_type
         The ID of the Deployment that was created as the result of an Automodel on this project.  Null if there is no Automodel for the project
    autopilot_mode:str, none_type
         The current autopilot mode. 0: Full Autopilot. 2: Manual Mode. 4: Comprehenisve Autopilot. null: Mode not set. Note: Quick Autopilot is defined by the `quickrun` field.
    catalog_id:str, none_type
         The ID of the AI catalog entry used to create the project, or null if not created from the AI catalog.
    catalog_version_id:str, none_type
         The ID of the AI catalog version used to create the project, or null if not created from the AI catalog.
    created:datetime
         The time of project creation.
    file_name:str
         The name of the dataset used to create the project.
    holdout_unlocked:bool
         Whether the holdout has been unlocked.
    id:str
         The ID of the project.
    max_train_pct:float
         The maximum percentage of the dataset that can be used to successfully train a model without going into the validation data.
    max_train_rows:int
         The maximum number of rows of the dataset that can be used to successfully train a model without going into the validation data.
    metric:str
         The metric used to select the best-performing models.
    partition:Partition
        
    positive_class:bool, date, datetime, dict, float, int, list, str, none_type
         If the project uses binary classification, the class designated to be the positive class.
    project_name:str
         The name of the project.
    quickrun:bool
         If the Autopilot mode is set to quick.
    recommender:Recommender
        
    scaleout_max_train_pct:float
         The maximum percentage of the dataset that can be used to successfully train a scaleout model without going into the validation data.  May exceed `maxTrainPct`, in which case only scaleout models can be trained up to this point.
    scaleout_max_train_rows:int
         The maximum number of rows of the dataset that can used be used to successfully train a scaleout model without going into the validation data.  May exceed `maxTrainRows`, in which case only scaleout models can be trained up to this point.
    stage:str
         The stage of the project. If modeling, then the target is successfully set and modeling or predictions can proceed.
    target:str
         The target of the project, null if project is unsupervised.
    target_type:str, none_type
         The type of the selected target. Null if the project is unsupervised.
    unsupervised_mode:bool, none_type
         Indicates whether a project is unsupervised.
    use_feature_discovery:bool
         Indicates whether a feature discovery project was created as opposed to a regular project
    autopilot_cluster_list:[int], none_type [optional]
         Optional. A list of integers where each value will be used as the number of clusters in Autopilot model(s) for unsupervised clustering projects. Cannot be specified unless unsupervisedMode is true and unsupervisedType is set to 'clustering'.. 
    external_time_series_baseline_dataset_metadata:ExternalTSBaselineMetadata [optional]
         
    feature_engineering_prediction_point:str, none_type [optional]
         The date column to be used as prediction point for time-based feature engineering.. 
    max_clusters:int, none_type [optional]
         Only valid when unsupervisedMode is True and unsupervisedType is 'clustering'. The maximum number of clusters allowed when training clustering models. If specified cannot be exceed the number of rows in a project's dataset divided by 50 and must be less than or equal to `minClusters`. If unsupervisedMode is True and unsupervisedType is 'clustering' then defaults to the number of rows in the project's dataset divided by 50 or 100 if that number of greater than 100.. 
    min_clusters:int, none_type [optional]
         Only valid when unsupervisedMode is True and unsupervisedType is 'clustering'. The minimum number of clusters allowed when training clustering models. If specified cannot be exceed the number of rows in a project's dataset divided by 50 and must be less than or equal to `maxClusters`. If unsupervisedMode is True and  unsupervisedType is 'clustering' then defaults to 2.. 
    segmentation:ProjectSegmentationInfoResponse [optional]
         
    unsupervised_type:str, none_type [optional]
         Only valid when unsupervisedMode is True. The type of unsupervised project, anomaly or clustering. If unsupervisedMode, defaults to 'anomaly'.. 
    """
    _converter = t.Dict(
        {
            t.Key("advanced_options"):  t.Any(),
            t.Key("automodel_deployment_id"):  t.String(),
            t.Key("autopilot_mode"):  t.String(),
            t.Key("catalog_id"):  t.String(),
            t.Key("catalog_version_id"):  t.String(),
            t.Key("created"):  t.DateTime(),
            t.Key("file_name"):  t.String(),
            t.Key("holdout_unlocked"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("max_train_pct"):  t.Float(),
            t.Key("max_train_rows"):  t.Int(),
            t.Key("metric"):  t.String(),
            t.Key("partition"):  t.Any(),
            t.Key("positive_class"):  t.Any(),
            t.Key("project_name"):  t.String(),
            t.Key("quickrun"):  t.Bool(),
            t.Key("recommender"):  t.Any(),
            t.Key("scaleout_max_train_pct"):  t.Float(),
            t.Key("scaleout_max_train_rows"):  t.Int(),
            t.Key("stage"):  t.String(),
            t.Key("target"):  t.String(),
            t.Key("target_type"):  t.String(),
            t.Key("unsupervised_mode"):  t.Bool(),
            t.Key("use_feature_discovery"):  t.Bool(),
            t.Key("autopilot_cluster_list", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("external_time_series_baseline_dataset_metadata", optional=True):  t.Any(),
            t.Key("feature_engineering_prediction_point", optional=True):  t.String(),
            t.Key("max_clusters", optional=True):  t.Int(),
            t.Key("min_clusters", optional=True):  t.Int(),
            t.Key("segmentation", optional=True):  t.Any(),
            t.Key("unsupervised_type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        advanced_options,
        automodel_deployment_id,
        autopilot_mode,
        catalog_id,
        catalog_version_id,
        created,
        file_name,
        holdout_unlocked,
        id,
        max_train_pct,
        max_train_rows,
        metric,
        partition,
        positive_class,
        project_name,
        quickrun,
        recommender,
        scaleout_max_train_pct,
        scaleout_max_train_rows,
        stage,
        target,
        target_type,
        unsupervised_mode,
        use_feature_discovery,
        autopilot_cluster_list=None,
        external_time_series_baseline_dataset_metadata=None,
        feature_engineering_prediction_point=None,
        max_clusters=None,
        min_clusters=None,
        segmentation=None,
        unsupervised_type=None,
    ):
        self.advanced_options = advanced_options
        self.automodel_deployment_id = automodel_deployment_id
        self.autopilot_mode = autopilot_mode
        self.catalog_id = catalog_id
        self.catalog_version_id = catalog_version_id
        self.created = created
        self.file_name = file_name
        self.holdout_unlocked = holdout_unlocked
        self.id = id
        self.max_train_pct = max_train_pct
        self.max_train_rows = max_train_rows
        self.metric = metric
        self.partition = partition
        self.positive_class = positive_class
        self.project_name = project_name
        self.quickrun = quickrun
        self.recommender = recommender
        self.scaleout_max_train_pct = scaleout_max_train_pct
        self.scaleout_max_train_rows = scaleout_max_train_rows
        self.stage = stage
        self.target = target
        self.target_type = target_type
        self.unsupervised_mode = unsupervised_mode
        self.use_feature_discovery = use_feature_discovery
        self.autopilot_cluster_list = autopilot_cluster_list
        self.external_time_series_baseline_dataset_metadata = external_time_series_baseline_dataset_metadata
        self.feature_engineering_prediction_point = feature_engineering_prediction_point
        self.max_clusters = max_clusters
        self.min_clusters = min_clusters
        self.segmentation = segmentation
        self.unsupervised_type = unsupervised_type

    def __repr__(self):
        return (
            "ProjectRetrieveResponse("
            "advanced_options={0.advanced_options}, "
            "automodel_deployment_id={0.automodel_deployment_id}, "
            "autopilot_mode={0.autopilot_mode}, "
            "catalog_id={0.catalog_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "created={0.created}, "
            "file_name={0.file_name}, "
            "holdout_unlocked={0.holdout_unlocked}, "
            "id={0.id}, "
            "max_train_pct={0.max_train_pct}, "
            "max_train_rows={0.max_train_rows}, "
            "metric={0.metric}, "
            "partition={0.partition}, "
            "positive_class={0.positive_class}, "
            "project_name={0.project_name}, "
            "quickrun={0.quickrun}, "
            "recommender={0.recommender}, "
            "scaleout_max_train_pct={0.scaleout_max_train_pct}, "
            "scaleout_max_train_rows={0.scaleout_max_train_rows}, "
            "stage={0.stage}, "
            "target={0.target}, "
            "target_type={0.target_type}, "
            "unsupervised_mode={0.unsupervised_mode}, "
            "use_feature_discovery={0.use_feature_discovery}, "
            "autopilot_cluster_list={0.autopilot_cluster_list}, "
            "external_time_series_baseline_dataset_metadata={0.external_time_series_baseline_dataset_metadata}, "
            "feature_engineering_prediction_point={0.feature_engineering_prediction_point}, "
            "max_clusters={0.max_clusters}, "
            "min_clusters={0.min_clusters}, "
            "segmentation={0.segmentation}, "
            "unsupervised_type={0.unsupervised_type}, "
        ).format(self)
