#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.datasets_credential import DatasetsCredential
from datarobot.models.full_api.generated.model.secondary_dataset_config import SecondaryDatasetConfig
from datarobot.models.full_api.generated.model.secondary_dataset_response import SecondaryDatasetResponse

class ProjectSecondaryDatasetConfigResponse(APIObject):
    """
    Attributes
    ----------
    created:datetime, none_type
         DR-formatted datetime, null for legacy (before DR 6.0) db records.
    creator_full_name:str, none_type
         Fullname or email of the user created this config. null for legacy (before DR 6.0) db records.
    creator_user_id:str, none_type
         ID of the user created this config, null for legacy (before DR 6.0) db records.
    id:str
         ID of the secondary datasets configuration.
    is_default:bool, none_type
         Secondary datasets config is default config or not.
    name:str, none_type
         Name of the secondary datasets config.
    project_id:str, none_type
         ID of the project.
    config:[SecondaryDatasetConfig], none_type [optional]
         Graph-specific secondary datasets. Deprecated in version v2.23.. 
    credential_ids:[DatasetsCredential], none_type [optional]
         List of credentials used by the secondary datasets if the datasets used in the configuration are from datasource.. 
    featurelist_id:str, none_type [optional]
         Id of the feature list.. 
    project_version:str, none_type [optional]
         DataRobot project version.. 
    secondary_datasets:[SecondaryDatasetResponse] [optional]
         List of secondary datasets used in the config.. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.DateTime(),
            t.Key("creator_full_name"):  t.String(),
            t.Key("creator_user_id"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("is_default"):  t.Bool(),
            t.Key("name"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("config", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("credential_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("featurelist_id", optional=True):  t.String(),
            t.Key("project_version", optional=True):  t.String(),
            t.Key("secondary_datasets", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        creator_full_name,
        creator_user_id,
        id,
        is_default,
        name,
        project_id,
        config=None,
        credential_ids=None,
        featurelist_id=None,
        project_version=None,
        secondary_datasets=None,
    ):
        self.created = created
        self.creator_full_name = creator_full_name
        self.creator_user_id = creator_user_id
        self.id = id
        self.is_default = is_default
        self.name = name
        self.project_id = project_id
        self.config = config
        self.credential_ids = credential_ids
        self.featurelist_id = featurelist_id
        self.project_version = project_version
        self.secondary_datasets = secondary_datasets

    def __repr__(self):
        return (
            "ProjectSecondaryDatasetConfigResponse("
            "created={0.created}, "
            "creator_full_name={0.creator_full_name}, "
            "creator_user_id={0.creator_user_id}, "
            "id={0.id}, "
            "is_default={0.is_default}, "
            "name={0.name}, "
            "project_id={0.project_id}, "
            "config={0.config}, "
            "credential_ids={0.credential_ids}, "
            "featurelist_id={0.featurelist_id}, "
            "project_version={0.project_version}, "
            "secondary_datasets={0.secondary_datasets}, "
        ).format(self)
