#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ProjectSegmentationInfoResponse(APIObject):
    """
    Attributes
    ----------
    segmentation_task_id:str
         ID of the Segmentation Task.
    parent_project_id:str, none_type [optional]
         ID of the original project.. 
    segment:str, none_type [optional]
         Segment value.. 
    """
    _converter = t.Dict(
        {
            t.Key("segmentation_task_id"):  t.String(),
            t.Key("parent_project_id", optional=True):  t.String(),
            t.Key("segment", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        segmentation_task_id,
        parent_project_id=None,
        segment=None,
    ):
        self.segmentation_task_id = segmentation_task_id
        self.parent_project_id = parent_project_id
        self.segment = segment

    def __repr__(self):
        return (
            "ProjectSegmentationInfoResponse("
            "segmentation_task_id={0.segmentation_task_id}, "
            "parent_project_id={0.parent_project_id}, "
            "segment={0.segment}, "
        ).format(self)
