#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ProjectStatusResponse(APIObject):
    """
    Attributes
    ----------
    autopilot_done:bool
         whether the current autopilot run has finished
    stage:str
         the current stage of the project, where modeling indicates that the target has been successfully set and modeling and predictions may proceed
    stage_description:str
         a description of the current stage of the project
    """
    _converter = t.Dict(
        {
            t.Key("autopilot_done"):  t.Bool(),
            t.Key("stage"):  t.String(),
            t.Key("stage_description"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        autopilot_done,
        stage,
        stage_description,
    ):
        self.autopilot_done = autopilot_done
        self.stage = stage
        self.stage_description = stage_description

    def __repr__(self):
        return (
            "ProjectStatusResponse("
            "autopilot_done={0.autopilot_done}, "
            "stage={0.stage}, "
            "stage_description={0.stage_description}, "
        ).format(self)
