#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ProjectUpdate(APIObject):
    """
    Attributes
    ----------
    gpu_worker_count:int [optional]
         The desired new number of gpu workers if the             number of gpu workers should be changed.             Must not exceed the number of gpu workers available to the user. `0` is allowed.             `-1` requests the maximum number available to the user.. 
    holdout_unlocked:str [optional]
         If specified, the holdout will be unlocked;             note that the holdout cannot be relocked after unlocking.  if omitted the server will use the default value of "true"
    project_description:str [optional]
         The new description of the project, if the description should be updated.. 
    project_name:str [optional]
         The new name of the project, if it should be renamed.. 
    worker_count:int [optional]
         The desired new number of workers if the             number of workers should be changed.             Must not exceed the number of workers available to the user. `0` is allowed.             (New in version v2.14) `-1` requests the maximum number available to the user.. 
    """
    _converter = t.Dict(
        {
            t.Key("gpu_worker_count", optional=True):  t.Int(),
            t.Key("holdout_unlocked", optional=True):  t.String(),
            t.Key("project_description", optional=True):  t.String(),
            t.Key("project_name", optional=True):  t.String(),
            t.Key("worker_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        gpu_worker_count=None,
        holdout_unlocked=None,
        project_description=None,
        project_name=None,
        worker_count=None,
    ):
        self.gpu_worker_count = gpu_worker_count
        self.holdout_unlocked = holdout_unlocked
        self.project_description = project_description
        self.project_name = project_name
        self.worker_count = worker_count

    def __repr__(self):
        return (
            "ProjectUpdate("
            "gpu_worker_count={0.gpu_worker_count}, "
            "holdout_unlocked={0.holdout_unlocked}, "
            "project_description={0.project_description}, "
            "project_name={0.project_name}, "
            "worker_count={0.worker_count}, "
        ).format(self)
