#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class RateLimits(APIObject):
    """
    Attributes
    ----------
    limit:int
         The number of instances of the resource allowed during the period
    resource:str
         The resource being limited
    window:int
         The length of the window, in 'windowType' units.  For example 60 seconds, or 1 month
    usage_tracked:bool [optional]
         Whether or not a persistent record of usage of this resource is recorded. 
    window_type:str [optional]
         The unit of time to use for the rate limit window..  if omitted the server will use the default value of "seconds"
    """
    _converter = t.Dict(
        {
            t.Key("limit"):  t.Int(),
            t.Key("resource"):  t.String(),
            t.Key("window"):  t.Int(),
            t.Key("usage_tracked", optional=True):  t.Bool(),
            t.Key("window_type", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        limit,
        resource,
        window,
        usage_tracked=None,
        window_type=None,
    ):
        self.limit = limit
        self.resource = resource
        self.window = window
        self.usage_tracked = usage_tracked
        self.window_type = window_type

    def __repr__(self):
        return (
            "RateLimits("
            "limit={0.limit}, "
            "resource={0.resource}, "
            "window={0.window}, "
            "usage_tracked={0.usage_tracked}, "
            "window_type={0.window_type}, "
        ).format(self)
