#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class RatingTableModelDetailsResponse(APIObject):
    """
    Attributes
    ----------
    blueprint_id:str, none_type
         the blueprint used to construct the model
    featurelist_id:str, none_type
         the ID of the featurelist used by the model
    featurelist_name:str
         the name of the featurelist used by the model
    id:str
         the ID of the model
    is_frozen:bool
         indicating whether the model is frozen, i.e. uses tuning parameters from a parent model
    is_starred:bool
         whether the model has been starred
    link_function:str, none_type
         the link function the final modeler uses in the blueprint. If no link function exists, returns null
    metrics:{str: (bool, date, datetime, dict, float, int, list, str, none_type)}
         the performance of the model according to various metrics, where each metric has validation, crossValidation, holdout, and training scores reported, or null if they have not been computed.
    model_category:str
         indicates what kind of model it is - will be `prime` for DataRobot Prime models, `blend` for blender models, `scaleout` for scaleout models, and `model` for all other models
    model_family:str
         the family model belongs to, e.g. SVM, GMB, etc.
    model_number:int
         number of the model on leaderboard.
    model_type:str
         identifies the model, e.g. `Nystroem Kernel SVM Regressor`
    monotonic_decreasing_featurelist_id:str, none_type
         the ID of the featurelist that defines the set of features with a monotonically decreasing relationship to the target. If null, no such constraints are enforced.
    monotonic_increasing_featurelist_id:str, none_type
         the ID of the featurelist that defines the set of features with a monotonically increasing relationship to the target. If null, no such constraints are enforced.
    parent_model_id:str, none_type
         if this model is frozen, this is the ID of the parent model. Otherwise Null.
    prediction_threshold:float
         threshold used for binary classification in predictions.
    prediction_threshold_read_only:bool
         indicates whether modification of a predictions threshold is forbidden. Since v2.22 threshold modification is allowed.
    processes:[str], none_type
         list of processes used by the model
    project_id:str
         the ID of the project to which the model belongs
    rating_table_id:str
         The rating table ID
    sample_pct:float
         the percentage of the dataset used in training the model
    supports_composable_ml:bool
         indicates whether this model is supported in Composable ML.
    supports_monotonic_constraints:bool
         whether this model supports enforcing monotonic constraints
    training_duration:str, none_type
         the duration spanned by the dates in the partition column for the data used to train the model
    training_end_date:datetime, none_type
         the end date of the dates in the partition column for the data used to train the model
    training_row_count:int
         the number of rows used to train the model
    training_start_date:datetime, none_type
         the start date of the dates in the partition column for the data used to train the model
    """
    _converter = t.Dict(
        {
            t.Key("blueprint_id"):  t.String(),
            t.Key("featurelist_id"):  t.String(),
            t.Key("featurelist_name"):  t.String(),
            t.Key("id"):  t.String(),
            t.Key("is_frozen"):  t.Bool(),
            t.Key("is_starred"):  t.Bool(),
            t.Key("link_function"):  t.String(),
            t.Key("metrics"):  t.Any(),
            t.Key("model_category"):  t.String(),
            t.Key("model_family"):  t.String(),
            t.Key("model_number"):  t.Int(),
            t.Key("model_type"):  t.String(),
            t.Key("monotonic_decreasing_featurelist_id"):  t.String(),
            t.Key("monotonic_increasing_featurelist_id"):  t.String(),
            t.Key("parent_model_id"):  t.String(),
            t.Key("prediction_threshold"):  t.Float(),
            t.Key("prediction_threshold_read_only"):  t.Bool(),
            t.Key("processes"):  t.List(t.Dict().allow_extra("*")),
            t.Key("project_id"):  t.String(),
            t.Key("rating_table_id"):  t.String(),
            t.Key("sample_pct"):  t.Float(),
            t.Key("supports_composable_ml"):  t.Bool(),
            t.Key("supports_monotonic_constraints"):  t.Bool(),
            t.Key("training_duration"):  t.String(),
            t.Key("training_end_date"):  t.DateTime(),
            t.Key("training_row_count"):  t.Int(),
            t.Key("training_start_date"):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        blueprint_id,
        featurelist_id,
        featurelist_name,
        id,
        is_frozen,
        is_starred,
        link_function,
        metrics,
        model_category,
        model_family,
        model_number,
        model_type,
        monotonic_decreasing_featurelist_id,
        monotonic_increasing_featurelist_id,
        parent_model_id,
        prediction_threshold,
        prediction_threshold_read_only,
        processes,
        project_id,
        rating_table_id,
        sample_pct,
        supports_composable_ml,
        supports_monotonic_constraints,
        training_duration,
        training_end_date,
        training_row_count,
        training_start_date,
    ):
        self.blueprint_id = blueprint_id
        self.featurelist_id = featurelist_id
        self.featurelist_name = featurelist_name
        self.id = id
        self.is_frozen = is_frozen
        self.is_starred = is_starred
        self.link_function = link_function
        self.metrics = metrics
        self.model_category = model_category
        self.model_family = model_family
        self.model_number = model_number
        self.model_type = model_type
        self.monotonic_decreasing_featurelist_id = monotonic_decreasing_featurelist_id
        self.monotonic_increasing_featurelist_id = monotonic_increasing_featurelist_id
        self.parent_model_id = parent_model_id
        self.prediction_threshold = prediction_threshold
        self.prediction_threshold_read_only = prediction_threshold_read_only
        self.processes = processes
        self.project_id = project_id
        self.rating_table_id = rating_table_id
        self.sample_pct = sample_pct
        self.supports_composable_ml = supports_composable_ml
        self.supports_monotonic_constraints = supports_monotonic_constraints
        self.training_duration = training_duration
        self.training_end_date = training_end_date
        self.training_row_count = training_row_count
        self.training_start_date = training_start_date

    def __repr__(self):
        return (
            "RatingTableModelDetailsResponse("
            "blueprint_id={0.blueprint_id}, "
            "featurelist_id={0.featurelist_id}, "
            "featurelist_name={0.featurelist_name}, "
            "id={0.id}, "
            "is_frozen={0.is_frozen}, "
            "is_starred={0.is_starred}, "
            "link_function={0.link_function}, "
            "metrics={0.metrics}, "
            "model_category={0.model_category}, "
            "model_family={0.model_family}, "
            "model_number={0.model_number}, "
            "model_type={0.model_type}, "
            "monotonic_decreasing_featurelist_id={0.monotonic_decreasing_featurelist_id}, "
            "monotonic_increasing_featurelist_id={0.monotonic_increasing_featurelist_id}, "
            "parent_model_id={0.parent_model_id}, "
            "prediction_threshold={0.prediction_threshold}, "
            "prediction_threshold_read_only={0.prediction_threshold_read_only}, "
            "processes={0.processes}, "
            "project_id={0.project_id}, "
            "rating_table_id={0.rating_table_id}, "
            "sample_pct={0.sample_pct}, "
            "supports_composable_ml={0.supports_composable_ml}, "
            "supports_monotonic_constraints={0.supports_monotonic_constraints}, "
            "training_duration={0.training_duration}, "
            "training_end_date={0.training_end_date}, "
            "training_row_count={0.training_row_count}, "
            "training_start_date={0.training_start_date}, "
        ).format(self)
