#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class RatingTableRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    created:float
         ISO-8601 timestamp of when the rating table record was created.
    id:str
         the ID of the rating table record
    model_id:str
         the model ID of a model that was created from the rating table.         May be null if a model has not been created from the rating table.
    model_job_id:int
         the qid of the job to create a model from this rating table.         Can be null if a model has not been created from the rating table.
    original_filename:str
         the filename of the uploaded rating table file
    parent_model_id:str
         the model ID of the model the rating table was modified from
    project_id:str
         the project ID of the rating table record
    rating_table_name:str
         the name of the rating table
    validation_error:str
         rating table validation error messages. If the rating table         was validated successfully, it will be an empty string.
    validation_job_id:str
         the qid of the created job to validate the rating table.         Can be null if the rating table has not been validated.
    validation_warnings:str
         rating table validation warning messages.
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.Float(),
            t.Key("id"):  t.String(),
            t.Key("model_id"):  t.String(),
            t.Key("model_job_id"):  t.Int(),
            t.Key("original_filename"):  t.String(),
            t.Key("parent_model_id"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("rating_table_name"):  t.String(),
            t.Key("validation_error"):  t.String(),
            t.Key("validation_job_id"):  t.String(),
            t.Key("validation_warnings"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        id,
        model_id,
        model_job_id,
        original_filename,
        parent_model_id,
        project_id,
        rating_table_name,
        validation_error,
        validation_job_id,
        validation_warnings,
    ):
        self.created = created
        self.id = id
        self.model_id = model_id
        self.model_job_id = model_job_id
        self.original_filename = original_filename
        self.parent_model_id = parent_model_id
        self.project_id = project_id
        self.rating_table_name = rating_table_name
        self.validation_error = validation_error
        self.validation_job_id = validation_job_id
        self.validation_warnings = validation_warnings

    def __repr__(self):
        return (
            "RatingTableRetrieveResponse("
            "created={0.created}, "
            "id={0.id}, "
            "model_id={0.model_id}, "
            "model_job_id={0.model_job_id}, "
            "original_filename={0.original_filename}, "
            "parent_model_id={0.parent_model_id}, "
            "project_id={0.project_id}, "
            "rating_table_name={0.rating_table_name}, "
            "validation_error={0.validation_error}, "
            "validation_job_id={0.validation_job_id}, "
            "validation_warnings={0.validation_warnings}, "
        ).format(self)
