#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class RelationshipGraph(APIObject):
    """
    Attributes
    ----------
    id:str
         The ID of the relationship graph
    linkage_keys:[str] [optional]
         An array of strings with names of columns specifying features from project dataset used as join keys to link with the graph. 
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("linkage_keys", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        linkage_keys=None,
    ):
        self.id = id
        self.linkage_keys = linkage_keys

    def __repr__(self):
        return (
            "RelationshipGraph("
            "id={0.id}, "
            "linkage_keys={0.linkage_keys}, "
        ).format(self)
