#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class RelationshipResponse(APIObject):
    """
    Attributes
    ----------
    dataset1_identifier:str, none_type
         Identifier of the first dataset in the relationship. If this is not provided, it represents the primary dataset.
    dataset1_keys:[str]
         column(s) in the first dataset that are used to join to the second dataset.
    dataset2_identifier:str
         Identifier of the second dataset in the relationship.
    dataset2_keys:[str]
         column(s) in the second dataset that are used to join to the first dataset.
    feature_derivation_window_end:int, none_type [optional]
         How many featureDerivationWindowUnits of each dataset's primary temporal key into the past relative to the datetimePartitionColumn the feature derivation window should end. Will be a non-positive integer, if present. If present, time-aware joins will be used.. 
    feature_derivation_window_start:int, none_type [optional]
         How many featureDerivationWindowUnits of each dataset's primary temporal key into the past relative to the datetimePartitionColumn the feature derivation window should begin. Will be a negative integer, if present. If present, time-aware joins will be used.. 
    feature_derivation_window_time_unit:str, none_type [optional]
         Time unit of the feature derivation window. Supported values are MILLISECOND, SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, YEAR. If present, time-aware joins will be used.. 
    prediction_point_rounding:int, none_type [optional]
         Can be null, closest value of predictionPointRoundingTimeUnit to round the prediction point into the past when applying the feature derivation window. Will be a positive integer, if present.. 
    prediction_point_rounding_time_unit:str, none_type [optional]
         Time unit of the prediction point rounding. Supported values are MILLISECOND, SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, YEAR.. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset1_identifier"):  t.String(),
            t.Key("dataset1_keys"):  t.List(t.Dict().allow_extra("*")),
            t.Key("dataset2_identifier"):  t.String(),
            t.Key("dataset2_keys"):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature_derivation_window_end", optional=True):  t.Int(),
            t.Key("feature_derivation_window_start", optional=True):  t.Int(),
            t.Key("feature_derivation_window_time_unit", optional=True):  t.String(),
            t.Key("prediction_point_rounding", optional=True):  t.Int(),
            t.Key("prediction_point_rounding_time_unit", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset1_identifier,
        dataset1_keys,
        dataset2_identifier,
        dataset2_keys,
        feature_derivation_window_end=None,
        feature_derivation_window_start=None,
        feature_derivation_window_time_unit=None,
        prediction_point_rounding=None,
        prediction_point_rounding_time_unit=None,
    ):
        self.dataset1_identifier = dataset1_identifier
        self.dataset1_keys = dataset1_keys
        self.dataset2_identifier = dataset2_identifier
        self.dataset2_keys = dataset2_keys
        self.feature_derivation_window_end = feature_derivation_window_end
        self.feature_derivation_window_start = feature_derivation_window_start
        self.feature_derivation_window_time_unit = feature_derivation_window_time_unit
        self.prediction_point_rounding = prediction_point_rounding
        self.prediction_point_rounding_time_unit = prediction_point_rounding_time_unit

    def __repr__(self):
        return (
            "RelationshipResponse("
            "dataset1_identifier={0.dataset1_identifier}, "
            "dataset1_keys={0.dataset1_keys}, "
            "dataset2_identifier={0.dataset2_identifier}, "
            "dataset2_keys={0.dataset2_keys}, "
            "feature_derivation_window_end={0.feature_derivation_window_end}, "
            "feature_derivation_window_start={0.feature_derivation_window_start}, "
            "feature_derivation_window_time_unit={0.feature_derivation_window_time_unit}, "
            "prediction_point_rounding={0.prediction_point_rounding}, "
            "prediction_point_rounding_time_unit={0.prediction_point_rounding_time_unit}, "
        ).format(self)
