#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dataset_definition import DatasetDefinition
from datarobot.models.full_api.generated.model.feature_discovery_setting import FeatureDiscoverySetting
from datarobot.models.full_api.generated.model.relationship import Relationship

class RelationshipsConfigCreate(APIObject):
    """
    Attributes
    ----------
    dataset_definitions:[DatasetDefinition]
         List of dataset definitions.
    relationships:[Relationship]
         List of relationship between datasets specified in datasetDefinitions.
    feature_discovery_mode:str [optional]
         Mode of feature discovery. Supported values are 'default' and 'manual'.. 
    feature_discovery_settings:[FeatureDiscoverySetting] [optional]
         List of feature discovery settings used to customize the feature discovery process. Applicable when feature_discovery_mode is 'manual'.. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_definitions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("relationships"):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature_discovery_mode", optional=True):  t.String(),
            t.Key("feature_discovery_settings", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_definitions,
        relationships,
        feature_discovery_mode=None,
        feature_discovery_settings=None,
    ):
        self.dataset_definitions = dataset_definitions
        self.relationships = relationships
        self.feature_discovery_mode = feature_discovery_mode
        self.feature_discovery_settings = feature_discovery_settings

    def __repr__(self):
        return (
            "RelationshipsConfigCreate("
            "dataset_definitions={0.dataset_definitions}, "
            "relationships={0.relationships}, "
            "feature_discovery_mode={0.feature_discovery_mode}, "
            "feature_discovery_settings={0.feature_discovery_settings}, "
        ).format(self)
