#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.dataset_definition_response import DatasetDefinitionResponse
from datarobot.models.full_api.generated.model.feature_discovery_setting_response import FeatureDiscoverySettingResponse
from datarobot.models.full_api.generated.model.relationship_response import RelationshipResponse

class RelationshipsConfigResponse(APIObject):
    """
    Attributes
    ----------
    dataset_definitions:[DatasetDefinitionResponse]
         List of dataset definitions.
    relationships:[RelationshipResponse]
         List of relationship between datasets specified in datasetDefinitions.
    feature_discovery_mode:str, none_type [optional]
         Mode of feature discovery. Supported values are 'default' and 'manual'.. 
    feature_discovery_settings:[FeatureDiscoverySettingResponse], none_type [optional]
         List of feature discovery settings used to customize the feature discovery process.. 
    id:str [optional]
         ID of relationships configuration.. 
    snowflake_push_down_compatible:bool, none_type [optional]
         Is this configuration compatible with pushdown computation on Snowflake?. 
    """
    _converter = t.Dict(
        {
            t.Key("dataset_definitions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("relationships"):  t.List(t.Dict().allow_extra("*")),
            t.Key("feature_discovery_mode", optional=True):  t.String(),
            t.Key("feature_discovery_settings", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("id", optional=True):  t.String(),
            t.Key("snowflake_push_down_compatible", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_definitions,
        relationships,
        feature_discovery_mode=None,
        feature_discovery_settings=None,
        id=None,
        snowflake_push_down_compatible=None,
    ):
        self.dataset_definitions = dataset_definitions
        self.relationships = relationships
        self.feature_discovery_mode = feature_discovery_mode
        self.feature_discovery_settings = feature_discovery_settings
        self.id = id
        self.snowflake_push_down_compatible = snowflake_push_down_compatible

    def __repr__(self):
        return (
            "RelationshipsConfigResponse("
            "dataset_definitions={0.dataset_definitions}, "
            "relationships={0.relationships}, "
            "feature_discovery_mode={0.feature_discovery_mode}, "
            "feature_discovery_settings={0.feature_discovery_settings}, "
            "id={0.id}, "
            "snowflake_push_down_compatible={0.snowflake_push_down_compatible}, "
        ).format(self)
