#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.prediction_remote_event_data import PredictionRemoteEventData
from datarobot.models.full_api.generated.model.remote_event_data import RemoteEventData

class RemoteEventCreate(APIObject):
    """
    Attributes
    ----------
    deployment_id:str
         The identifier of the deployment associated with the event.
    event_type:str
         The type of the event. Labels in all_lower_case are deprecated.
    timestamp:datetime
         The time when the event occurred.
    data:RemoteEventData [optional]
         
    message:str [optional]
         Descriptive message for health events.. 
    org_id:str, none_type [optional]
         The identifier of the organization associated with the event.. 
    prediction_request_data:PredictionRemoteEventData [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("deployment_id"):  t.String(),
            t.Key("event_type"):  t.String(),
            t.Key("timestamp"):  t.DateTime(),
            t.Key("data", optional=True):  t.Any(),
            t.Key("message", optional=True):  t.String(),
            t.Key("org_id", optional=True):  t.String(),
            t.Key("prediction_request_data", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        deployment_id,
        event_type,
        timestamp,
        data=None,
        message=None,
        org_id=None,
        prediction_request_data=None,
    ):
        self.deployment_id = deployment_id
        self.event_type = event_type
        self.timestamp = timestamp
        self.data = data
        self.message = message
        self.org_id = org_id
        self.prediction_request_data = prediction_request_data

    def __repr__(self):
        return (
            "RemoteEventCreate("
            "deployment_id={0.deployment_id}, "
            "event_type={0.event_type}, "
            "timestamp={0.timestamp}, "
            "data={0.data}, "
            "message={0.message}, "
            "org_id={0.org_id}, "
            "prediction_request_data={0.prediction_request_data}, "
        ).format(self)
