#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ResourceUsage(APIObject):
    """
    Attributes
    ----------
    current_usage:int
         The usage accumulated within the current window.
    max_usage:int
         The maximum value currentUsage can take before requests using this resource are denied.
    resource:str
         The rate limit resource this usage applies to.
    time_to_expire:int
         The number of seconds until this usage resets to zero.
    """
    _converter = t.Dict(
        {
            t.Key("current_usage"):  t.Int(),
            t.Key("max_usage"):  t.Int(),
            t.Key("resource"):  t.String(),
            t.Key("time_to_expire"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        current_usage,
        max_usage,
        resource,
        time_to_expire,
    ):
        self.current_usage = current_usage
        self.max_usage = max_usage
        self.resource = resource
        self.time_to_expire = time_to_expire

    def __repr__(self):
        return (
            "ResourceUsage("
            "current_usage={0.current_usage}, "
            "max_usage={0.max_usage}, "
            "resource={0.resource}, "
            "time_to_expire={0.time_to_expire}, "
        ).format(self)
