#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.resource_usage import ResourceUsage

class ResourceUsageResponse(APIObject):
    """
    Attributes
    ----------
    count:int
         The number of resource usage records.
    next:str, none_type
         URL pointing to the next page.
    previous:str, none_type
         URL pointing to the previous page.
    usage:[ResourceUsage]
         The resource usage records.
    """
    _converter = t.Dict(
        {
            t.Key("count"):  t.Int(),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("usage"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        count,
        next,
        previous,
        usage,
    ):
        self.count = count
        self.next = next
        self.previous = previous
        self.usage = usage

    def __repr__(self):
        return (
            "ResourceUsageResponse("
            "count={0.count}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "usage={0.usage}, "
        ).format(self)
