#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class RetrainModel(APIObject):
    """
    Attributes
    ----------
    model_id:str
         The model to be retrained
    featurelist_id:str [optional]
         If specified, the model will be trained using that featurelist, otherwise the model will be trained on the same feature list as before.. 
    monotonic_decreasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically decreasing relationship to the target. If null, no such constraints are enforced.. 
    monotonic_increasing_featurelist_id:str, none_type [optional]
         The ID of the featurelist that defines the set of features with a monotonically increasing relationship to the target. If null, no such constraints are enforced.. 
    sample_pct:float [optional]
         The percentage of the dataset to use to use to train the model. The specified percentage should be between 0 and 100. If not specified, original model sample percent will be used.. 
    scoring_type:str [optional]
         Validation is available for any partitioning. If the project uses cross validation, `crossValidation` may be used to indicate that all available training/validation combinations should be used.. 
    training_row_count:int [optional]
         The number of rows to use to train the model. If not specified, original model training row count will be used.. 
    """
    _converter = t.Dict(
        {
            t.Key("model_id"):  t.String(),
            t.Key("featurelist_id", optional=True):  t.String(),
            t.Key("monotonic_decreasing_featurelist_id", optional=True):  t.String(),
            t.Key("monotonic_increasing_featurelist_id", optional=True):  t.String(),
            t.Key("sample_pct", optional=True):  t.Float(),
            t.Key("scoring_type", optional=True):  t.String(),
            t.Key("training_row_count", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        model_id,
        featurelist_id=None,
        monotonic_decreasing_featurelist_id=None,
        monotonic_increasing_featurelist_id=None,
        sample_pct=None,
        scoring_type=None,
        training_row_count=None,
    ):
        self.model_id = model_id
        self.featurelist_id = featurelist_id
        self.monotonic_decreasing_featurelist_id = monotonic_decreasing_featurelist_id
        self.monotonic_increasing_featurelist_id = monotonic_increasing_featurelist_id
        self.sample_pct = sample_pct
        self.scoring_type = scoring_type
        self.training_row_count = training_row_count

    def __repr__(self):
        return (
            "RetrainModel("
            "model_id={0.model_id}, "
            "featurelist_id={0.featurelist_id}, "
            "monotonic_decreasing_featurelist_id={0.monotonic_decreasing_featurelist_id}, "
            "monotonic_increasing_featurelist_id={0.monotonic_increasing_featurelist_id}, "
            "sample_pct={0.sample_pct}, "
            "scoring_type={0.scoring_type}, "
            "training_row_count={0.training_row_count}, "
        ).format(self)
