#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.shap_warnings import ShapWarnings

class RetrievePredictionMetadataObject(APIObject):
    """
    Attributes
    ----------
    id:str
         The id of the prediction record.
    includes_prediction_intervals:bool
         Whether the predictions include prediction intervals.
    model_id:str
         The model id used for predictions.
    prediction_intervals_size:int, none_type
         For time series projects only. If prediction intervals were computed, what percentile they represent. Will be ``None`` if ``includePredictionIntervals`` is ``False``.
    project_id:str
         The project id of the predictions.
    url:str
         The url at which you can download the predictions.
    actual_value_column:str, none_type [optional]
         For time series unsupervised projects only. Actual value column can be used to calculate the classification metrics and insights.. 
    dataset_id:str, none_type [optional]
         Deprecated alias for `predictionDatasetId`.. 
    explanation_algorithm:str, none_type [optional]
         The selected algorithm to use for prediction explanations. At present, the only acceptable value is `shap`, which selects the SHapley Additive exPlanations (SHAP) explainer. Defaults to null (no prediction explanations).. 
    feature_derivation_window_counts:int, none_type [optional]
         For time series projects with partial history only. Indicates how many points were used in during feature derivation.. 
    forecast_point:datetime, none_type [optional]
         For time series projects only. The time in the dataset relative to which predictions were generated.. 
    max_explanations:int, none_type [optional]
         The maximum number of prediction explanations values to be returned with each row in the `predictions` json array. Null indicates `no limit`. Will be present only if `explanationAlgorithm` was set.. 
    prediction_dataset_id:str, none_type [optional]
         The dataset id where the prediction data comes from. The field is available via `/api/v2/projects/<projectId>/predictionsMetadata/` route and replaced on `datasetId`in deprecated `/api/v2/projects/<projectId>/predictions/` endpoint.. 
    prediction_threshold:float, none_type [optional]
         Threshold used for binary classification in predictions.. 
    predictions_end_date:datetime, none_type [optional]
         For time series projects only. The end date for bulk predictions, exclusive. Note that this parameter was used for generating historical predictions using the training data, not for future predictions.. 
    predictions_start_date:datetime, none_type [optional]
         For time series projects only. The start date for bulk predictions. Note that this parameter was used for generating historical predictions using the training data, not for future predictions.. 
    shap_warnings:ShapWarnings [optional]
         
    """
    _converter = t.Dict(
        {
            t.Key("id"):  t.String(),
            t.Key("includes_prediction_intervals"):  t.Bool(),
            t.Key("model_id"):  t.String(),
            t.Key("prediction_intervals_size"):  t.Int(),
            t.Key("project_id"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("actual_value_column", optional=True):  t.String(),
            t.Key("dataset_id", optional=True):  t.String(),
            t.Key("explanation_algorithm", optional=True):  t.String(),
            t.Key("feature_derivation_window_counts", optional=True):  t.Int(),
            t.Key("forecast_point", optional=True):  t.DateTime(),
            t.Key("max_explanations", optional=True):  t.Int(),
            t.Key("prediction_dataset_id", optional=True):  t.String(),
            t.Key("prediction_threshold", optional=True):  t.Float(),
            t.Key("predictions_end_date", optional=True):  t.DateTime(),
            t.Key("predictions_start_date", optional=True):  t.DateTime(),
            t.Key("shap_warnings", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        id,
        includes_prediction_intervals,
        model_id,
        prediction_intervals_size,
        project_id,
        url,
        actual_value_column=None,
        dataset_id=None,
        explanation_algorithm=None,
        feature_derivation_window_counts=None,
        forecast_point=None,
        max_explanations=None,
        prediction_dataset_id=None,
        prediction_threshold=None,
        predictions_end_date=None,
        predictions_start_date=None,
        shap_warnings=None,
    ):
        self.id = id
        self.includes_prediction_intervals = includes_prediction_intervals
        self.model_id = model_id
        self.prediction_intervals_size = prediction_intervals_size
        self.project_id = project_id
        self.url = url
        self.actual_value_column = actual_value_column
        self.dataset_id = dataset_id
        self.explanation_algorithm = explanation_algorithm
        self.feature_derivation_window_counts = feature_derivation_window_counts
        self.forecast_point = forecast_point
        self.max_explanations = max_explanations
        self.prediction_dataset_id = prediction_dataset_id
        self.prediction_threshold = prediction_threshold
        self.predictions_end_date = predictions_end_date
        self.predictions_start_date = predictions_start_date
        self.shap_warnings = shap_warnings

    def __repr__(self):
        return (
            "RetrievePredictionMetadataObject("
            "id={0.id}, "
            "includes_prediction_intervals={0.includes_prediction_intervals}, "
            "model_id={0.model_id}, "
            "prediction_intervals_size={0.prediction_intervals_size}, "
            "project_id={0.project_id}, "
            "url={0.url}, "
            "actual_value_column={0.actual_value_column}, "
            "dataset_id={0.dataset_id}, "
            "explanation_algorithm={0.explanation_algorithm}, "
            "feature_derivation_window_counts={0.feature_derivation_window_counts}, "
            "forecast_point={0.forecast_point}, "
            "max_explanations={0.max_explanations}, "
            "prediction_dataset_id={0.prediction_dataset_id}, "
            "prediction_threshold={0.prediction_threshold}, "
            "predictions_end_date={0.predictions_end_date}, "
            "predictions_start_date={0.predictions_start_date}, "
            "shap_warnings={0.shap_warnings}, "
        ).format(self)
