#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.roc_points_response import RocPointsResponse

class RocCurveForDatasets(APIObject):
    """
    Attributes
    ----------
    dataset_id:str
         The ID of dataset which was used to compute ROC curve.
    negative_class_predictions:[float]
         List of example predictions for the negative class.
    positive_class_predictions:[float]
         List of example predictions for the negative class.
    roc_points:RocPointsResponse
        
    """
    _converter = t.Dict(
        {
            t.Key("dataset_id"):  t.String(),
            t.Key("negative_class_predictions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("positive_class_predictions"):  t.List(t.Dict().allow_extra("*")),
            t.Key("roc_points"):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        dataset_id,
        negative_class_predictions,
        positive_class_predictions,
        roc_points,
    ):
        self.dataset_id = dataset_id
        self.negative_class_predictions = negative_class_predictions
        self.positive_class_predictions = positive_class_predictions
        self.roc_points = roc_points

    def __repr__(self):
        return (
            "RocCurveForDatasets("
            "dataset_id={0.dataset_id}, "
            "negative_class_predictions={0.negative_class_predictions}, "
            "positive_class_predictions={0.positive_class_predictions}, "
            "roc_points={0.roc_points}, "
        ).format(self)
