#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class RocPointsResponse(APIObject):
    """
    Attributes
    ----------
    accuracy:float
         Accuracy for given threshold.
    f1_score:float
         F1 score.
    false_negative_score:int
         False negative score.
    false_positive_rate:float
         False positive rate.
    false_positive_score:int
         False positive score.
    fraction_predicted_as_negative:float
         Fraction of data that will be predicted as negative.
    fraction_predicted_as_positive:float
         Fraction of data that will be predicted as positive.
    lift_negative:float
         Lift for the negative class.
    lift_positive:float
         Lift for the positive class.
    matthews_correlation_coefficient:float
         Matthews correlation coefficient.
    negative_predictive_value:float
         Negative predictive value.
    positive_predictive_value:float
         Positive predictive value.
    threshold:float
         Value of threshold for this ROC point.
    true_negative_rate:float
         True negative rate.
    true_negative_score:int
         True negative score.
    true_positive_rate:float
         True positive rate.
    true_positive_score:int
         True positive score.
    """
    _converter = t.Dict(
        {
            t.Key("accuracy"):  t.Float(),
            t.Key("f1_score"):  t.Float(),
            t.Key("false_negative_score"):  t.Int(),
            t.Key("false_positive_rate"):  t.Float(),
            t.Key("false_positive_score"):  t.Int(),
            t.Key("fraction_predicted_as_negative"):  t.Float(),
            t.Key("fraction_predicted_as_positive"):  t.Float(),
            t.Key("lift_negative"):  t.Float(),
            t.Key("lift_positive"):  t.Float(),
            t.Key("matthews_correlation_coefficient"):  t.Float(),
            t.Key("negative_predictive_value"):  t.Float(),
            t.Key("positive_predictive_value"):  t.Float(),
            t.Key("threshold"):  t.Float(),
            t.Key("true_negative_rate"):  t.Float(),
            t.Key("true_negative_score"):  t.Int(),
            t.Key("true_positive_rate"):  t.Float(),
            t.Key("true_positive_score"):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        accuracy,
        f1_score,
        false_negative_score,
        false_positive_rate,
        false_positive_score,
        fraction_predicted_as_negative,
        fraction_predicted_as_positive,
        lift_negative,
        lift_positive,
        matthews_correlation_coefficient,
        negative_predictive_value,
        positive_predictive_value,
        threshold,
        true_negative_rate,
        true_negative_score,
        true_positive_rate,
        true_positive_score,
    ):
        self.accuracy = accuracy
        self.f1_score = f1_score
        self.false_negative_score = false_negative_score
        self.false_positive_rate = false_positive_rate
        self.false_positive_score = false_positive_score
        self.fraction_predicted_as_negative = fraction_predicted_as_negative
        self.fraction_predicted_as_positive = fraction_predicted_as_positive
        self.lift_negative = lift_negative
        self.lift_positive = lift_positive
        self.matthews_correlation_coefficient = matthews_correlation_coefficient
        self.negative_predictive_value = negative_predictive_value
        self.positive_predictive_value = positive_predictive_value
        self.threshold = threshold
        self.true_negative_rate = true_negative_rate
        self.true_negative_score = true_negative_score
        self.true_positive_rate = true_positive_rate
        self.true_positive_score = true_positive_score

    def __repr__(self):
        return (
            "RocPointsResponse("
            "accuracy={0.accuracy}, "
            "f1_score={0.f1_score}, "
            "false_negative_score={0.false_negative_score}, "
            "false_positive_rate={0.false_positive_rate}, "
            "false_positive_score={0.false_positive_score}, "
            "fraction_predicted_as_negative={0.fraction_predicted_as_negative}, "
            "fraction_predicted_as_positive={0.fraction_predicted_as_positive}, "
            "lift_negative={0.lift_negative}, "
            "lift_positive={0.lift_positive}, "
            "matthews_correlation_coefficient={0.matthews_correlation_coefficient}, "
            "negative_predictive_value={0.negative_predictive_value}, "
            "positive_predictive_value={0.positive_predictive_value}, "
            "threshold={0.threshold}, "
            "true_negative_rate={0.true_negative_rate}, "
            "true_negative_score={0.true_negative_score}, "
            "true_positive_rate={0.true_positive_rate}, "
            "true_positive_score={0.true_positive_score}, "
        ).format(self)
