#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class S3Credentials(APIObject):
    """
    Attributes
    ----------
    credential_type:str
         The type of these credentials, 's3' here.. defaults to "s3", must be one of ["s3", ]
    aws_access_key_id:str, none_type [optional]
         The S3 AWS access key ID..  if omitted the server will use the default value of "null"
    aws_secret_access_key:str, none_type [optional]
         The S3 AWS secret access key..  if omitted the server will use the default value of "null"
    aws_session_token:str, none_type [optional]
         The S3 AWS session token..  if omitted the server will use the default value of "null"
    """
    _converter = t.Dict(
        {
            t.Key("credential_type"):  t.String(),
            t.Key("aws_access_key_id", optional=True):  t.String(),
            t.Key("aws_secret_access_key", optional=True):  t.String(),
            t.Key("aws_session_token", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        credential_type,
        aws_access_key_id=None,
        aws_secret_access_key=None,
        aws_session_token=None,
    ):
        self.credential_type = credential_type
        self.aws_access_key_id = aws_access_key_id
        self.aws_secret_access_key = aws_secret_access_key
        self.aws_session_token = aws_session_token

    def __repr__(self):
        return (
            "S3Credentials("
            "credential_type={0.credential_type}, "
            "aws_access_key_id={0.aws_access_key_id}, "
            "aws_secret_access_key={0.aws_secret_access_key}, "
            "aws_session_token={0.aws_session_token}, "
        ).format(self)
