#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class S3Intake(APIObject):
    """
    Attributes
    ----------
    type:str
         Type name for this intake type. defaults to "s3", must be one of ["s3", ]
    url:str
         URL for the CSV file
    credential_id:str, none_type [optional]
         Use the specified credential to access the url. 
    format:str [optional]
         Type of input file format.  if omitted the server will use the default value of "csv"
    """
    _converter = t.Dict(
        {
            t.Key("type"):  t.String(),
            t.Key("url"):  t.String(),
            t.Key("credential_id", optional=True):  t.String(),
            t.Key("format", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        type,
        url,
        credential_id=None,
        format=None,
    ):
        self.type = type
        self.url = url
        self.credential_id = credential_id
        self.format = format

    def __repr__(self):
        return (
            "S3Intake("
            "type={0.type}, "
            "url={0.url}, "
            "credential_id={0.credential_id}, "
            "format={0.format}, "
        ).format(self)
