#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.saml_attribute_mapping import SamlAttributeMapping
from datarobot.models.full_api.generated.model.saml_client_config import SamlClientConfig

class SamlAdvancedConfiguration(APIObject):
    """
    Attributes
    ----------
    saml_attributes_mapping:SamlAttributeMapping
        
    saml_client_configuration:SamlClientConfig
        
    digest_algorithm:str [optional]
         Algorithm for calculating digest.. 
    signature_algorithm:str [optional]
         Algorithm for calculating signature.. 
    """
    _converter = t.Dict(
        {
            t.Key("saml_attributes_mapping"):  t.Any(),
            t.Key("saml_client_configuration"):  t.Any(),
            t.Key("digest_algorithm", optional=True):  t.String(),
            t.Key("signature_algorithm", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        saml_attributes_mapping,
        saml_client_configuration,
        digest_algorithm=None,
        signature_algorithm=None,
    ):
        self.saml_attributes_mapping = saml_attributes_mapping
        self.saml_client_configuration = saml_client_configuration
        self.digest_algorithm = digest_algorithm
        self.signature_algorithm = signature_algorithm

    def __repr__(self):
        return (
            "SamlAdvancedConfiguration("
            "saml_attributes_mapping={0.saml_attributes_mapping}, "
            "saml_client_configuration={0.saml_client_configuration}, "
            "digest_algorithm={0.digest_algorithm}, "
            "signature_algorithm={0.signature_algorithm}, "
        ).format(self)
