#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.encryption_keypairs import EncryptionKeypairs

class SamlClientConfig(APIObject):
    """
    Attributes
    ----------
    cert_file:str [optional]
         Path to the pem file with a single certificate.. 
    cert_file_value:str [optional]
         A single certificate pem file content as a single string. Has priority over cert_file.. 
    encryption_keypairs:[EncryptionKeypairs] [optional]
         Indicates which certificates will be used for encryption capabilities.. 
    id_attr_name:str [optional]
         Attribute is required to be set to 'Id' value when Okta encrypted assertions are used. 
    id_attr_name_crypto:str [optional]
         Attribute is required to be set to 'Id' value when Okta encrypted assertions are used. 
    key_file:str [optional]
         Path to the private key pem file.. 
    key_file_value:str [optional]
         The private key pem file content as a single string. Has priority over key_file.. 
    """
    _converter = t.Dict(
        {
            t.Key("cert_file", optional=True):  t.String(),
            t.Key("cert_file_value", optional=True):  t.String(),
            t.Key("encryption_keypairs", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("id_attr_name", optional=True):  t.String(),
            t.Key("id_attr_name_crypto", optional=True):  t.String(),
            t.Key("key_file", optional=True):  t.String(),
            t.Key("key_file_value", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        cert_file=None,
        cert_file_value=None,
        encryption_keypairs=None,
        id_attr_name=None,
        id_attr_name_crypto=None,
        key_file=None,
        key_file_value=None,
    ):
        self.cert_file = cert_file
        self.cert_file_value = cert_file_value
        self.encryption_keypairs = encryption_keypairs
        self.id_attr_name = id_attr_name
        self.id_attr_name_crypto = id_attr_name_crypto
        self.key_file = key_file
        self.key_file_value = key_file_value

    def __repr__(self):
        return (
            "SamlClientConfig("
            "cert_file={0.cert_file}, "
            "cert_file_value={0.cert_file_value}, "
            "encryption_keypairs={0.encryption_keypairs}, "
            "id_attr_name={0.id_attr_name}, "
            "id_attr_name_crypto={0.id_attr_name_crypto}, "
            "key_file={0.key_file}, "
            "key_file_value={0.key_file_value}, "
        ).format(self)
