#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SamlGroupMappingResponse(APIObject):
    """
    Attributes
    ----------
    datarobot_group_id:str
         DataRobot group ID.
    idp_group_id:str
         A name of the identity provider group.
    datarobot_group_name:str [optional]
         DataRobot group name.. 
    """
    _converter = t.Dict(
        {
            t.Key("datarobot_group_id"):  t.String(),
            t.Key("idp_group_id"):  t.String(),
            t.Key("datarobot_group_name", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        datarobot_group_id,
        idp_group_id,
        datarobot_group_name=None,
    ):
        self.datarobot_group_id = datarobot_group_id
        self.idp_group_id = idp_group_id
        self.datarobot_group_name = datarobot_group_name

    def __repr__(self):
        return (
            "SamlGroupMappingResponse("
            "datarobot_group_id={0.datarobot_group_id}, "
            "idp_group_id={0.idp_group_id}, "
            "datarobot_group_name={0.datarobot_group_name}, "
        ).format(self)
