#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.schedule import Schedule
from datarobot.models.full_api.generated.model.scheduled_job_status import ScheduledJobStatus

class ScheduledJobResponse(APIObject):
    """
    Attributes
    ----------
    enabled:bool
         True if the job is enabled and false if the job is disabled.
    id:str
         ID of scheduled prediction job
    schedule:Schedule
        
    scheduled_job_id:str
         ID of this scheduled job.
    status:ScheduledJobStatus
        
    type_id:str
         Job type of the scheduled job
    created_by:str, none_type [optional]
         User name of the creator. 
    deployment_id:str, none_type [optional]
         ID of the deployment this scheduled job is created from.. 
    integration_type_id:str, none_type [optional]
         The specific type of of prediction integration.. 
    integration_type_name:str [optional]
         filter by integration type name.. 
    name:str, none_type [optional]
         Name of the scheduled job.. 
    updated_at:datetime, none_type [optional]
         Time of last modification. 
    """
    _converter = t.Dict(
        {
            t.Key("enabled"):  t.Bool(),
            t.Key("id"):  t.String(),
            t.Key("schedule"):  t.Any(),
            t.Key("scheduled_job_id"):  t.String(),
            t.Key("status"):  t.Any(),
            t.Key("type_id"):  t.String(),
            t.Key("created_by", optional=True):  t.String(),
            t.Key("deployment_id", optional=True):  t.String(),
            t.Key("integration_type_id", optional=True):  t.String(),
            t.Key("integration_type_name", optional=True):  t.String(),
            t.Key("name", optional=True):  t.String(),
            t.Key("updated_at", optional=True):  t.DateTime(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        enabled,
        id,
        schedule,
        scheduled_job_id,
        status,
        type_id,
        created_by=None,
        deployment_id=None,
        integration_type_id=None,
        integration_type_name=None,
        name=None,
        updated_at=None,
    ):
        self.enabled = enabled
        self.id = id
        self.schedule = schedule
        self.scheduled_job_id = scheduled_job_id
        self.status = status
        self.type_id = type_id
        self.created_by = created_by
        self.deployment_id = deployment_id
        self.integration_type_id = integration_type_id
        self.integration_type_name = integration_type_name
        self.name = name
        self.updated_at = updated_at

    def __repr__(self):
        return (
            "ScheduledJobResponse("
            "enabled={0.enabled}, "
            "id={0.id}, "
            "schedule={0.schedule}, "
            "scheduled_job_id={0.scheduled_job_id}, "
            "status={0.status}, "
            "type_id={0.type_id}, "
            "created_by={0.created_by}, "
            "deployment_id={0.deployment_id}, "
            "integration_type_id={0.integration_type_id}, "
            "integration_type_name={0.integration_type_name}, "
            "name={0.name}, "
            "updated_at={0.updated_at}, "
        ).format(self)
