#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class ScheduledJobStatus(APIObject):
    """
    Attributes
    ----------
    running:bool
         `true` or `false` depending on whether the job is currently running.
    last_failed_run:datetime, none_type [optional]
         Date and time of the last failed run.. 
    last_successful_run:datetime, none_type [optional]
         Date and time of the last successful run.. 
    next_run_time:datetime, none_type [optional]
         Date and time of the next run.. 
    queue_position:int, none_type [optional]
         Position of the job in the queue Job. The value will show 0 if the job is about to run, otherwise, the number will be greater than 0 if currently queued, or None if the job is not currently running.. 
    """
    _converter = t.Dict(
        {
            t.Key("running"):  t.Bool(),
            t.Key("last_failed_run", optional=True):  t.DateTime(),
            t.Key("last_successful_run", optional=True):  t.DateTime(),
            t.Key("next_run_time", optional=True):  t.DateTime(),
            t.Key("queue_position", optional=True):  t.Int(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        running,
        last_failed_run=None,
        last_successful_run=None,
        next_run_time=None,
        queue_position=None,
    ):
        self.running = running
        self.last_failed_run = last_failed_run
        self.last_successful_run = last_successful_run
        self.next_run_time = next_run_time
        self.queue_position = queue_position

    def __repr__(self):
        return (
            "ScheduledJobStatus("
            "running={0.running}, "
            "last_failed_run={0.last_failed_run}, "
            "last_successful_run={0.last_successful_run}, "
            "next_run_time={0.next_run_time}, "
            "queue_position={0.queue_position}, "
        ).format(self)
