#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.scheduled_job_response import ScheduledJobResponse

class ScheduledJobsListResponse(APIObject):
    """
    Attributes
    ----------
    data:[ScheduledJobResponse]
         List of scheduled jobs
    next:str, none_type
         URL pointing to the next page (if null, there is no next page).
    previous:str, none_type
         URL pointing to the previous page (if null, there is no previous page).
    total_count:int
         The total number of items across all pages.
    count:int [optional]
         Number of items returned on this page.. 
    updated_at:datetime [optional]
         Time of last modification. 
    updated_by:str [optional]
         User ID of last modifier. 
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("next"):  t.String(),
            t.Key("previous"):  t.String(),
            t.Key("total_count"):  t.Int(),
            t.Key("count", optional=True):  t.Int(),
            t.Key("updated_at", optional=True):  t.DateTime(),
            t.Key("updated_by", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        next,
        previous,
        total_count,
        count=None,
        updated_at=None,
        updated_by=None,
    ):
        self.data = data
        self.next = next
        self.previous = previous
        self.total_count = total_count
        self.count = count
        self.updated_at = updated_at
        self.updated_by = updated_by

    def __repr__(self):
        return (
            "ScheduledJobsListResponse("
            "data={0.data}, "
            "next={0.next}, "
            "previous={0.previous}, "
            "total_count={0.total_count}, "
            "count={0.count}, "
            "updated_at={0.updated_at}, "
            "updated_by={0.updated_by}, "
        ).format(self)
