#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SecondaryDataset(APIObject):
    """
    Attributes
    ----------
    catalog_id:str
         Id of the catalog item version.
    catalog_version_id:str
         Id of the catalog item.
    identifier:str
         Short name of this table (used directly as part of generated feature names).
    snapshot_policy:str [optional]
         Type of snapshot policy to use by the dataset..  if omitted the server will use the default value of "latest"
    """
    _converter = t.Dict(
        {
            t.Key("catalog_id"):  t.String(),
            t.Key("catalog_version_id"):  t.String(),
            t.Key("identifier"):  t.String(),
            t.Key("snapshot_policy", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        catalog_id,
        catalog_version_id,
        identifier,
        snapshot_policy=None,
    ):
        self.catalog_id = catalog_id
        self.catalog_version_id = catalog_version_id
        self.identifier = identifier
        self.snapshot_policy = snapshot_policy

    def __repr__(self):
        return (
            "SecondaryDataset("
            "catalog_id={0.catalog_id}, "
            "catalog_version_id={0.catalog_version_id}, "
            "identifier={0.identifier}, "
            "snapshot_policy={0.snapshot_policy}, "
        ).format(self)
