#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.secondary_dataset import SecondaryDataset

class SecondaryDatasetConfig(APIObject):
    """
    Attributes
    ----------
    feature_engineering_graph_id:str
         Id of the feature engineering graph
    secondary_datasets:[SecondaryDataset]
         list of secondary datasets used by the feature engineering graph
    """
    _converter = t.Dict(
        {
            t.Key("feature_engineering_graph_id"):  t.String(),
            t.Key("secondary_datasets"):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        feature_engineering_graph_id,
        secondary_datasets,
    ):
        self.feature_engineering_graph_id = feature_engineering_graph_id
        self.secondary_datasets = secondary_datasets

    def __repr__(self):
        return (
            "SecondaryDatasetConfig("
            "feature_engineering_graph_id={0.feature_engineering_graph_id}, "
            "secondary_datasets={0.secondary_datasets}, "
        ).format(self)
