#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.datasets_credential import DatasetsCredential
from datarobot.models.full_api.generated.model.deployment_secondary_dataset import DeploymentSecondaryDataset

class SecondaryDatasetConfigResponse(APIObject):
    """
    Attributes
    ----------
    created:datetime, none_type
         DR-formatted datetime, null for legacy (before DR 6.0) db records
    creator_full_name:str, none_type
         Fullname or email of the user created this config. null for legacy (before DR 6.0) db records
    creator_user_id:str, none_type
         ID of the user created this config, null for legacy (before DR 6.0) db records
    featurelist_id:str, none_type
         Id of the feature list
    is_default:bool
         Secondary datasets config is default config or not
    is_deleted:bool
         Secondary datasets config is soft deleted or not
    name:str, none_type
         Name of the secondary datasets config
    project_id:str, none_type
         ID of the project
    secondary_dataset_config_id:str
         ID of the secondary datasets configuration
    credential_ids:[DatasetsCredential], none_type [optional]
         List of credentials used by the secondary datasets if the datasets used in the configuration are from datasource. 
    secondary_datasets:[DeploymentSecondaryDataset] [optional]
         List of secondary datasets used in the config. 
    """
    _converter = t.Dict(
        {
            t.Key("created"):  t.DateTime(),
            t.Key("creator_full_name"):  t.String(),
            t.Key("creator_user_id"):  t.String(),
            t.Key("featurelist_id"):  t.String(),
            t.Key("is_default"):  t.Bool(),
            t.Key("is_deleted"):  t.Bool(),
            t.Key("name"):  t.String(),
            t.Key("project_id"):  t.String(),
            t.Key("secondary_dataset_config_id"):  t.String(),
            t.Key("credential_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("secondary_datasets", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        created,
        creator_full_name,
        creator_user_id,
        featurelist_id,
        is_default,
        is_deleted,
        name,
        project_id,
        secondary_dataset_config_id,
        credential_ids=None,
        secondary_datasets=None,
    ):
        self.created = created
        self.creator_full_name = creator_full_name
        self.creator_user_id = creator_user_id
        self.featurelist_id = featurelist_id
        self.is_default = is_default
        self.is_deleted = is_deleted
        self.name = name
        self.project_id = project_id
        self.secondary_dataset_config_id = secondary_dataset_config_id
        self.credential_ids = credential_ids
        self.secondary_datasets = secondary_datasets

    def __repr__(self):
        return (
            "SecondaryDatasetConfigResponse("
            "created={0.created}, "
            "creator_full_name={0.creator_full_name}, "
            "creator_user_id={0.creator_user_id}, "
            "featurelist_id={0.featurelist_id}, "
            "is_default={0.is_default}, "
            "is_deleted={0.is_deleted}, "
            "name={0.name}, "
            "project_id={0.project_id}, "
            "secondary_dataset_config_id={0.secondary_dataset_config_id}, "
            "credential_ids={0.credential_ids}, "
            "secondary_datasets={0.secondary_datasets}, "
        ).format(self)
