#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.datasets_credential import DatasetsCredential

class SecondaryDatasetConfigUpdate(APIObject):
    """
    Attributes
    ----------
    secondary_dataset_config_id:str
         ID of the secondary datasets configuration to be used at the time of prediction
    credentials_ids:[DatasetsCredential] [optional]
         List of credentials used by the secondary datasets. 
    """
    _converter = t.Dict(
        {
            t.Key("secondary_dataset_config_id"):  t.String(),
            t.Key("credentials_ids", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        secondary_dataset_config_id,
        credentials_ids=None,
    ):
        self.secondary_dataset_config_id = secondary_dataset_config_id
        self.credentials_ids = credentials_ids

    def __repr__(self):
        return (
            "SecondaryDatasetConfigUpdate("
            "secondary_dataset_config_id={0.secondary_dataset_config_id}, "
            "credentials_ids={0.credentials_ids}, "
        ).format(self)
