#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.secondary_dataset import SecondaryDataset
from datarobot.models.full_api.generated.model.secondary_dataset_config import SecondaryDatasetConfig

class SecondaryDatasetCreate(APIObject):
    """
    Attributes
    ----------
    name:str
         Name of the configuration.
    config:[SecondaryDatasetConfig] [optional]
         Graph-specific secondary datasets. Deprecated in version v2.23. 
    featurelist_id:str [optional]
         Feature list ID of the configuration.. 
    model_id:str [optional]
         ID of the model.. 
    save:bool [optional]
         ID of the model..  if omitted the server will use the default value of True
    secondary_datasets:[SecondaryDataset] [optional]
         Whether to save the configuration. If set to False the configuration is validated but not saved. Defaults to True.. 
    """
    _converter = t.Dict(
        {
            t.Key("name"):  t.String(),
            t.Key("config", optional=True):  t.List(t.Dict().allow_extra("*")),
            t.Key("featurelist_id", optional=True):  t.String(),
            t.Key("model_id", optional=True):  t.String(),
            t.Key("save", optional=True):  t.Bool(),
            t.Key("secondary_datasets", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        name,
        config=None,
        featurelist_id=None,
        model_id=None,
        save=None,
        secondary_datasets=None,
    ):
        self.name = name
        self.config = config
        self.featurelist_id = featurelist_id
        self.model_id = model_id
        self.save = save
        self.secondary_datasets = secondary_datasets

    def __repr__(self):
        return (
            "SecondaryDatasetCreate("
            "name={0.name}, "
            "config={0.config}, "
            "featurelist_id={0.featurelist_id}, "
            "model_id={0.model_id}, "
            "save={0.save}, "
            "secondary_datasets={0.secondary_datasets}, "
        ).format(self)
