#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SecondaryDatasetsConfig(APIObject):
    """
    Attributes
    ----------
    config_id:str
         ID of the secondary datasets configuration
    config_name:str
         Name of the secondary datasets config
    updated:str
         Timestamp when configuration was updated on the given deployment
    username:str
         Name of the user who made the update
    """
    _converter = t.Dict(
        {
            t.Key("config_id"):  t.String(),
            t.Key("config_name"):  t.String(),
            t.Key("updated"):  t.String(),
            t.Key("username"):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        config_id,
        config_name,
        updated,
        username,
    ):
        self.config_id = config_id
        self.config_name = config_name
        self.updated = updated
        self.username = username

    def __repr__(self):
        return (
            "SecondaryDatasetsConfig("
            "config_id={0.config_id}, "
            "config_name={0.config_name}, "
            "updated={0.updated}, "
            "username={0.username}, "
        ).format(self)
