#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.instructions_field import InstructionsField

class SectionDataRobot(APIObject):
    """
    Attributes
    ----------
    content_id:str
         The identifier of the content in the section. This attribute identifies what is going to be rendered in the section.
    title:str
         Section Title
    type:str
         Section owned by DataRobot. The content of this section type is controlled by DataRobot (see ``contentId`` attribute). Users can add sub-sections to it.. defaults to "datarobot", must be one of ["datarobot", ]
    description:str, none_type [optional]
         Section description. 
    instructions:InstructionsField [optional]
         
    locked:bool [optional]
         Locked section flag. 
    sections:[dict], none_type [optional]
         List of section objects representing the structure of the document. Each section can have sub-sections that have the same schema as the parent section, e.g. the structure is recursive. The limit of nesting sections is 5. Total number of sections is limited to 500. . 
    """
    _converter = t.Dict(
        {
            t.Key("content_id"):  t.String(),
            t.Key("title"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("description", optional=True):  t.String(),
            t.Key("instructions", optional=True):  t.Any(),
            t.Key("locked", optional=True):  t.Bool(),
            t.Key("sections", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        content_id,
        title,
        type,
        description=None,
        instructions=None,
        locked=None,
        sections=None,
    ):
        self.content_id = content_id
        self.title = title
        self.type = type
        self.description = description
        self.instructions = instructions
        self.locked = locked
        self.sections = sections

    def __repr__(self):
        return (
            "SectionDataRobot("
            "content_id={0.content_id}, "
            "title={0.title}, "
            "type={0.type}, "
            "description={0.description}, "
            "instructions={0.instructions}, "
            "locked={0.locked}, "
            "sections={0.sections}, "
        ).format(self)
