#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SectionTableOfContents(APIObject):
    """
    Attributes
    ----------
    title:str
         Section Title
    type:str
         Table of contents. This section has no additional attributes.. defaults to "table_of_contents", must be one of ["table_of_contents", ]
    locked:bool [optional]
         Locked section flag. 
    """
    _converter = t.Dict(
        {
            t.Key("title"):  t.String(),
            t.Key("type"):  t.String(),
            t.Key("locked", optional=True):  t.Bool(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        title,
        type,
        locked=None,
    ):
        self.title = title
        self.type = type
        self.locked = locked

    def __repr__(self):
        return (
            "SectionTableOfContents("
            "title={0.title}, "
            "type={0.type}, "
            "locked={0.locked}, "
        ).format(self)
