#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SegmentAnalysis(APIObject):
    """
    Attributes
    ----------
    enabled:bool
         Indicates whether service health, drift, and accuracy are tracked for segments of prediction data.
    attributes:[str] [optional]
         The list of segment attributes selected for tracking.. 
    """
    _converter = t.Dict(
        {
            t.Key("enabled"):  t.Bool(),
            t.Key("attributes", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        enabled,
        attributes=None,
    ):
        self.enabled = enabled
        self.attributes = attributes

    def __repr__(self):
        return (
            "SegmentAnalysis("
            "enabled={0.enabled}, "
            "attributes={0.attributes}, "
        ).format(self)
