#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SegmentAnalysisUpdate(APIObject):
    """
    Attributes
    ----------
    enabled:bool
         Indicates whether service health, drift, and accuracy are tracked for segments of prediction data.
    attributes:[str] [optional]
         The segment attributes to be tracked. Note that only categorical columns can be specified as tracked segment attributes. The target column may not be specified. 
    """
    _converter = t.Dict(
        {
            t.Key("enabled"):  t.Bool(),
            t.Key("attributes", optional=True):  t.List(t.Dict().allow_extra("*")),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        enabled,
        attributes=None,
    ):
        self.enabled = enabled
        self.attributes = attributes

    def __repr__(self):
        return (
            "SegmentAnalysisUpdate("
            "enabled={0.enabled}, "
            "attributes={0.attributes}, "
        ).format(self)
