#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject

class SeriesAccuracyRetrieveDataResponse(APIObject):
    """
    Attributes
    ----------
    backtesting_score:float
         The backtesting score for this series. If backtesting has not been run for this model, this score will be null.
    duration:str
         The duration of this series formatted as an ISO 8601 duration string.
    multiseries_id:str
         A DataRobot-generated ID corresponding to a single series in a multiseries dataset.
    multiseries_values:[str]
         The actual values of series ID columns from the dataset.
    row_count:int
         The number of rows available for this series in the input dataset.
    validation_score:float
         The validation set score for this series
    end_date:datetime, none_type [optional]
         The ISO-formatted end date of this series.. 
    holdout_score:float, none_type [optional]
         The holdout set score for this series. If holdout is locked for the project, this score will be null.. 
    start_date:datetime, none_type [optional]
         The ISO-formatted start date of this series.. 
    target_average:bool, date, datetime, dict, float, int, list, str, none_type [optional]
         For regression projects, this is the average (mean) value of target values for this series.For classification projects, this is the ratio of the positive class in the target for this series.. 
    """
    _converter = t.Dict(
        {
            t.Key("backtesting_score"):  t.Float(),
            t.Key("duration"):  t.String(),
            t.Key("multiseries_id"):  t.String(),
            t.Key("multiseries_values"):  t.List(t.Dict().allow_extra("*")),
            t.Key("row_count"):  t.Int(),
            t.Key("validation_score"):  t.Float(),
            t.Key("end_date", optional=True):  t.DateTime(),
            t.Key("holdout_score", optional=True):  t.Float(),
            t.Key("start_date", optional=True):  t.DateTime(),
            t.Key("target_average", optional=True):  t.Any(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        backtesting_score,
        duration,
        multiseries_id,
        multiseries_values,
        row_count,
        validation_score,
        end_date=None,
        holdout_score=None,
        start_date=None,
        target_average=None,
    ):
        self.backtesting_score = backtesting_score
        self.duration = duration
        self.multiseries_id = multiseries_id
        self.multiseries_values = multiseries_values
        self.row_count = row_count
        self.validation_score = validation_score
        self.end_date = end_date
        self.holdout_score = holdout_score
        self.start_date = start_date
        self.target_average = target_average

    def __repr__(self):
        return (
            "SeriesAccuracyRetrieveDataResponse("
            "backtesting_score={0.backtesting_score}, "
            "duration={0.duration}, "
            "multiseries_id={0.multiseries_id}, "
            "multiseries_values={0.multiseries_values}, "
            "row_count={0.row_count}, "
            "validation_score={0.validation_score}, "
            "end_date={0.end_date}, "
            "holdout_score={0.holdout_score}, "
            "start_date={0.start_date}, "
            "target_average={0.target_average}, "
        ).format(self)
