#
# Copyright 2021 DataRobot, Inc. and its affiliates.
#
# All rights reserved.
#
# DataRobot, Inc.
#
# This is proprietary source code of DataRobot, Inc. and its
# affiliates.
#
# Released under the terms of DataRobot Tool and Utility Agreement.
"""
Autogenerated DataRobot python client file.  Please don't modify.
"""

import trafaret as t
from datarobot.models.api_object import APIObject
from datarobot.models.full_api.generated.model.series_accuracy_retrieve_data_response import SeriesAccuracyRetrieveDataResponse

class SeriesAccuracyRetrieveResponse(APIObject):
    """
    Attributes
    ----------
    data:[SeriesAccuracyRetrieveDataResponse]
         An array of available multiseries identifiers and column values.
    query_series_count:int
         The total number of series after filtering is applied.
    total_series_count:int
         The total number of series in the project dataset.
    next:str, none_type [optional]
         A URL pointing to the next page (if null, there is no next page).. 
    previous:str, none_type [optional]
         A URL pointing to the previous page (if null, there is no previous page).. 
    """
    _converter = t.Dict(
        {
            t.Key("data"):  t.List(t.Dict().allow_extra("*")),
            t.Key("query_series_count"):  t.Int(),
            t.Key("total_series_count"):  t.Int(),
            t.Key("next", optional=True):  t.String(),
            t.Key("previous", optional=True):  t.String(),
        }
    ).ignore_extra("*")

    def __init__(
        self,
        data,
        query_series_count,
        total_series_count,
        next=None,
        previous=None,
    ):
        self.data = data
        self.query_series_count = query_series_count
        self.total_series_count = total_series_count
        self.next = next
        self.previous = previous

    def __repr__(self):
        return (
            "SeriesAccuracyRetrieveResponse("
            "data={0.data}, "
            "query_series_count={0.query_series_count}, "
            "total_series_count={0.total_series_count}, "
            "next={0.next}, "
            "previous={0.previous}, "
        ).format(self)
